/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.parsing.CharacterHandler;
import org.jboss.as.cli.parsing.EscapeCharacterState;
import org.jboss.as.cli.parsing.ParsingContext;

public class LineBreakHandler
implements CharacterHandler {
    private final boolean fallbackToEscape;
    private final boolean leaveOnLnBreak;

    public LineBreakHandler(boolean leaveOnLnBreak, boolean fallbackToEscape) {
        this.leaveOnLnBreak = leaveOnLnBreak;
        this.fallbackToEscape = fallbackToEscape;
    }

    @Override
    public void handle(ParsingContext ctx) throws CommandFormatException {
        if (ctx.getCharacter() == '\\') {
            if (ctx.getInput().regionMatches(ctx.getLocation() + 1, Util.LINE_SEPARATOR, 0, Util.LINE_SEPARATOR.length())) {
                if (this.leaveOnLnBreak) {
                    ctx.leaveState();
                }
            } else if (this.fallbackToEscape) {
                ctx.enterState(EscapeCharacterState.INSTANCE);
            } else {
                this.doHandle(ctx);
            }
        } else {
            this.doHandle(ctx);
        }
    }

    protected void doHandle(ParsingContext ctx) throws CommandFormatException {
    }
}

