/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.cli.ArgumentValueConverter;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.ModelNodeFormatter;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.OperationCommandWithDescription;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.util.SimpleTable;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class GenericTypeOperationHandler
extends BatchModeCommandHandler {
    protected final String commandName;
    protected final String idProperty;
    protected final String nodeType;
    protected final ArgumentWithValue profile;
    protected final ArgumentWithValue name;
    protected final ArgumentWithValue operation;
    protected final Set<String> excludedOps;
    protected final ArgumentWithoutValue helpProperties;
    protected final ArgumentWithoutValue helpCommands;
    private final Map<String, CommandArgument> staticArgs = new HashMap<String, CommandArgument>();
    private Map<String, ArgumentValueConverter> propConverters;
    private Map<String, CommandLineCompleter> valueCompleters;
    private Map<String, OperationCommandWithDescription> customHandlers;
    private WritePropertyHandler writePropHandler;
    private Map<String, OperationCommand> opHandlers;

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty) {
        this(ctx, nodeType, idProperty, "read-attribute", "read-children-names", "read-children-resources", "read-children-types", "read-operation-description", "read-operation-names", "read-resource-description", "validate-address", "write-attribute", "undefine-attribute", "whoami");
    }

    public GenericTypeOperationHandler(CommandContext ctx, String nodeType, String idProperty, String ... excludeOperations) {
        super(ctx, "generic-type-operation", true);
        if (nodeType == null || nodeType.isEmpty()) {
            throw new IllegalArgumentException("Node type is " + (nodeType == null ? "null." : "empty."));
        }
        if (nodeType.startsWith("/profile=") || nodeType.startsWith("profile=")) {
            int nextSep = nodeType.indexOf(47, 7);
            if (nextSep < 0) {
                throw new IllegalArgumentException("Failed to determine the path after the profile in '" + nodeType + "'.");
            }
            this.nodeType = nodeType = nodeType.substring(nextSep);
        } else {
            this.nodeType = nodeType;
        }
        this.helpArg = new ArgumentWithoutValue((CommandHandlerWithArguments)this, "--help", "-h");
        this.addRequiredPath(nodeType);
        this.commandName = this.getRequiredType();
        if (this.commandName == null) {
            throw new IllegalArgumentException("The node path doesn't end on a type: '" + nodeType + "'");
        }
        this.idProperty = idProperty;
        this.excludedOps = excludeOperations != null ? new HashSet<String>(Arrays.asList(excludeOperations)) : Collections.emptySet();
        this.profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
            }
        }), "--profile"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!GenericTypeOperationHandler.this.isDependsOnProfile()) {
                    return false;
                }
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            @Override
            public Collection<String> getAllCandidates(CommandContext ctx) {
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (profileName == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                address.toNode(GenericTypeOperationHandler.this.getRequiredType(), "?");
                Collection<String> ops = ctx.getOperationCandidatesProvider().getOperationNames(ctx, address);
                ops.removeAll(GenericTypeOperationHandler.this.excludedOps);
                if (GenericTypeOperationHandler.this.customHandlers != null) {
                    ops.addAll(GenericTypeOperationHandler.this.customHandlers.keySet());
                }
                return ops;
            }
        }), 0, "--operation"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.operation.addCantAppearAfter(this.helpArg);
        this.name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

            public List<String> getAllCandidates(CommandContext ctx) {
                ModelControllerClient client = ctx.getModelControllerClient();
                if (client == null) {
                    return Collections.emptyList();
                }
                DefaultOperationRequestAddress address = new DefaultOperationRequestAddress();
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                    String profileName = GenericTypeOperationHandler.this.profile.getValue(ctx.getParsedCommandLine());
                    if (GenericTypeOperationHandler.this.profile == null) {
                        return Collections.emptyList();
                    }
                    address.toNode("profile", profileName);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    address.toNode(node.getType(), node.getName());
                }
                return Util.getNodeNames(ctx.getModelControllerClient(), address, GenericTypeOperationHandler.this.getRequiredType());
            }
        }), idProperty == null ? "--name" : "--" + idProperty){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode() && !GenericTypeOperationHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.name.addCantAppearAfter(this.helpArg);
        this.helpArg.addCantAppearAfter(this.name);
        this.helpProperties = new ArgumentWithoutValue(this, "--properties");
        this.helpProperties.addRequiredPreceding(this.helpArg);
        this.helpProperties.addCantAppearAfter(this.operation);
        this.helpCommands = new ArgumentWithoutValue(this, "--commands");
        this.helpCommands.addRequiredPreceding(this.helpArg);
        this.helpCommands.addCantAppearAfter(this.operation);
        this.helpCommands.addCantAppearAfter(this.helpProperties);
        this.helpProperties.addCantAppearAfter(this.helpCommands);
        this.staticArgs.put(this.helpArg.getFullName(), this.helpArg);
        this.staticArgs.put(this.helpCommands.getFullName(), this.helpCommands);
        this.staticArgs.put(this.helpProperties.getFullName(), this.helpProperties);
        this.staticArgs.put(this.profile.getFullName(), this.profile);
        this.staticArgs.put(this.name.getFullName(), this.name);
        this.staticArgs.put(this.operation.getFullName(), this.operation);
    }

    public void addValueConverter(String propertyName, ArgumentValueConverter converter) {
        if (this.propConverters == null) {
            this.propConverters = new HashMap<String, ArgumentValueConverter>();
        }
        this.propConverters.put(propertyName, converter);
    }

    public void addValueCompleter(String propertyName, CommandLineCompleter completer) {
        if (this.valueCompleters == null) {
            this.valueCompleters = new HashMap<String, CommandLineCompleter>();
        }
        this.valueCompleters.put(propertyName, completer);
    }

    public void addHandler(String name, OperationCommandWithDescription handler) {
        if (this.customHandlers == null) {
            this.customHandlers = new HashMap<String, OperationCommandWithDescription>();
        }
        this.customHandlers.put(name, handler);
    }

    @Override
    public CommandArgument getArgument(CommandContext ctx, String name) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs.get(name);
            }
        }
        catch (CommandFormatException e) {
            return null;
        }
        String op = this.operation.getValue(args);
        return this.getHandler(ctx, op).getArgument(ctx, name);
    }

    @Override
    public Collection<CommandArgument> getArguments(CommandContext ctx) {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        try {
            if (!this.name.isValueComplete(args)) {
                return this.staticArgs.values();
            }
        }
        catch (CommandFormatException e) {
            return Collections.emptyList();
        }
        String op = this.operation.getValue(args);
        return this.getHandler(ctx, op).getArguments(ctx);
    }

    private OperationCommand getHandler(CommandContext ctx, String op) {
        ModelNode descr;
        OperationCommand opHandler;
        if (op == null) {
            if (this.writePropHandler == null) {
                List<Object> propList;
                this.writePropHandler = new WritePropertyHandler();
                try {
                    propList = this.getNodeProperties(ctx);
                }
                catch (CommandFormatException e) {
                    propList = Collections.emptyList();
                }
                for (int i = 0; i < propList.size(); ++i) {
                    Property prop = (Property)propList.get(i);
                    ModelNode propDescr = prop.getValue();
                    if (!propDescr.has("access-type") || !"read-write".equals(propDescr.get("access-type").asString())) continue;
                    ModelType type = null;
                    CommandLineCompleter valueCompleter = null;
                    ArgumentValueConverter valueConverter = null;
                    if (this.propConverters != null) {
                        valueConverter = this.propConverters.get(prop.getName());
                    }
                    if (this.valueCompleters != null) {
                        valueCompleter = this.valueCompleters.get(prop.getName());
                    }
                    if (valueConverter == null) {
                        valueConverter = ArgumentValueConverter.DEFAULT;
                        if (propDescr.has("type")) {
                            type = propDescr.get("type").asType();
                            if (ModelType.BOOLEAN == type) {
                                if (valueCompleter == null) {
                                    valueCompleter = SimpleTabCompleter.BOOLEAN;
                                }
                            } else if (prop.getName().endsWith("properties")) {
                                valueConverter = ArgumentValueConverter.PROPERTIES;
                            } else if (ModelType.LIST == type) {
                                valueConverter = propDescr.hasDefined("value-type") && propDescr.get("value-type").asType() == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                            } else if (ModelType.OBJECT == type) {
                                valueConverter = ArgumentValueConverter.OBJECT;
                            }
                        }
                    }
                    ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                    this.writePropHandler.addArgument(arg);
                }
            }
            return this.writePropHandler;
        }
        if (this.customHandlers != null && this.customHandlers.containsKey(op) && (opHandler = (OperationCommand)this.customHandlers.get(op)) != null) {
            return opHandler;
        }
        if (this.opHandlers != null && (opHandler = this.opHandlers.get(op)) != null) {
            return opHandler;
        }
        try {
            descr = this.getOperationDescription(ctx, op);
        }
        catch (CommandLineException e) {
            return null;
        }
        if (this.opHandlers == null) {
            this.opHandlers = new HashMap<String, OperationCommand>();
        }
        OpHandler opHandler2 = new OpHandler(op);
        this.opHandlers.put(op, opHandler2);
        opHandler2.addArgument(this.headers);
        if (descr != null && descr.has("request-properties")) {
            List propList = descr.get("request-properties").asPropertyList();
            for (Property prop : propList) {
                ModelNode propDescr = prop.getValue();
                ModelType type = null;
                CommandLineCompleter valueCompleter = null;
                ArgumentValueConverter valueConverter = null;
                if (this.propConverters != null) {
                    valueConverter = this.propConverters.get(prop.getName());
                }
                if (this.valueCompleters != null) {
                    valueCompleter = this.valueCompleters.get(prop.getName());
                }
                if (valueConverter == null) {
                    valueConverter = ArgumentValueConverter.DEFAULT;
                    if (propDescr.has("type")) {
                        type = propDescr.get("type").asType();
                        if (ModelType.BOOLEAN == type) {
                            if (valueCompleter == null) {
                                valueCompleter = SimpleTabCompleter.BOOLEAN;
                            }
                        } else if (prop.getName().endsWith("properties")) {
                            valueConverter = ArgumentValueConverter.PROPERTIES;
                        } else if (ModelType.LIST == type) {
                            valueConverter = propDescr.hasDefined("value-type") && propDescr.get("value-type").asType() == ModelType.PROPERTY ? ArgumentValueConverter.PROPERTIES : ArgumentValueConverter.LIST;
                        } else if (ModelType.OBJECT == type) {
                            valueConverter = ArgumentValueConverter.OBJECT;
                        }
                    }
                }
                ArgumentWithValue arg = new ArgumentWithValue((CommandHandlerWithArguments)this, valueCompleter, valueConverter, "--" + prop.getName());
                opHandler2.addArgument(arg);
            }
        }
        return opHandler2;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, String name) {
        return true;
    }

    @Override
    public boolean hasArgument(CommandContext ctx, int index) {
        return true;
    }

    @Override
    public void addArgument(CommandArgument arg) {
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
    }

    @Override
    public ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        String operation = this.operation.getValue(ctx.getParsedCommandLine());
        OperationCommand opHandler = this.getHandler(ctx, operation);
        if (opHandler == null) {
            throw new CommandFormatException("Unexpected command '" + operation + "'");
        }
        return opHandler.buildRequest(ctx);
    }

    @Override
    protected void handleResponse(CommandContext ctx, ModelNode opResponse, boolean composite) throws CommandFormatException {
        if (!Util.isSuccess(opResponse)) {
            throw new CommandFormatException(Util.getFailureDescription(opResponse));
        }
        StringBuilder buf = this.formatResponse(ctx, opResponse, composite, null);
        if (buf != null) {
            ctx.printLine(buf.toString());
        }
    }

    protected StringBuilder formatResponse(CommandContext ctx, ModelNode opResponse, boolean composite, StringBuilder buf) throws CommandFormatException {
        Set keys;
        if (opResponse.hasDefined("result")) {
            ModelNode result = opResponse.get("result");
            if (composite) {
                try {
                    keys = result.keys();
                }
                catch (Exception e) {
                    throw new CommandFormatException("Failed to get step results from a composite operation response " + opResponse);
                }
                for (String key : keys) {
                    ModelNode stepResponse = result.get(key);
                    buf = this.formatResponse(ctx, stepResponse, false, buf);
                }
            } else {
                ModelNodeFormatter.ModelNodeFormatterBase formatter = ModelNodeFormatter.Factory.forType(result.getType());
                if (buf == null) {
                    buf = new StringBuilder();
                }
                formatter.format(buf, 0, result);
            }
        }
        if (opResponse.hasDefined("response-headers")) {
            ModelNode headers = opResponse.get("response-headers");
            keys = headers.keys();
            SimpleTable table = new SimpleTable(2);
            for (String key : keys) {
                table.addLine(new String[]{key, headers.get(key).asString()});
            }
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append(Util.LINE_SEPARATOR);
            }
            table.append(buf, false);
        }
        return buf;
    }

    @Override
    protected void printHelp(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.helpProperties.isPresent(args)) {
            this.printProperties(ctx, this.getNodeProperties(ctx));
            return;
        }
        if (this.helpCommands.isPresent(args)) {
            this.printSupportedCommands(ctx);
            return;
        }
        String operationName = this.operation.getValue(args);
        if (operationName == null) {
            this.printNodeDescription(ctx);
            return;
        }
        ModelNode result = this.getOperationDescription(ctx, operationName);
        if (!result.hasDefined("description")) {
            throw new CommandLineException("Operation description is not available.");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("\nDESCRIPTION:\n\n");
        buf.append(result.get("description").asString());
        ctx.printLine(buf.toString());
        if (result.hasDefined("request-properties")) {
            this.printProperties(ctx, result.get("request-properties").asPropertyList());
        } else {
            this.printProperties(ctx, Collections.<Property>emptyList());
        }
    }

    protected void printProperties(CommandContext ctx, List<Property> props) {
        int spaces;
        StringBuilder prop;
        LinkedHashMap<String, StringBuilder> requiredProps = new LinkedHashMap<String, StringBuilder>();
        requiredProps.put(this.name.getFullName(), new StringBuilder().append("Required argument in commands which identifies the instance to execute the command against."));
        LinkedHashMap<String, StringBuilder> optionalProps = new LinkedHashMap<String, StringBuilder>();
        String accessType = null;
        for (Property attr : props) {
            String type;
            ModelNode value = attr.getValue();
            if (value.has("access-type")) {
                accessType = value.get("access-type").asString();
            }
            boolean required = value.hasDefined("required") ? value.get("required").asBoolean() : false;
            StringBuilder descr = new StringBuilder();
            String string = type = value.has("type") ? value.get("type").asString() : "no type info";
            if (value.hasDefined("description")) {
                descr.append('(');
                descr.append(type);
                if (accessType != null) {
                    descr.append(',').append(accessType);
                }
                descr.append(") ");
                descr.append(value.get("description").asString());
            } else if (descr.length() == 0) {
                descr.append("no description.");
            }
            if (required) {
                if (this.idProperty != null && this.idProperty.equals(attr.getName())) {
                    if (descr.charAt(descr.length() - 1) != '.') {
                        descr.append('.');
                    }
                    ((StringBuilder)requiredProps.get(this.name.getFullName())).insert(0, ' ').insert(0, descr.toString());
                    continue;
                }
                requiredProps.put("--" + attr.getName(), descr);
                continue;
            }
            optionalProps.put("--" + attr.getName(), descr);
        }
        ctx.printLine("\n");
        if (accessType == null) {
            ctx.printLine("REQUIRED ARGUMENTS:\n");
        }
        for (String argName : requiredProps.keySet()) {
            prop = new StringBuilder();
            prop.append(' ').append(argName);
            spaces = 28 - prop.length();
            do {
                prop.append(' ');
            } while (--spaces >= 0);
            prop.append("- ").append((CharSequence)requiredProps.get(argName));
            ctx.printLine(prop.toString());
        }
        if (!optionalProps.isEmpty()) {
            if (accessType == null) {
                ctx.printLine("\n\nOPTIONAL ARGUMENTS:\n");
            }
            for (String argName : optionalProps.keySet()) {
                prop = new StringBuilder();
                prop.append(' ').append(argName);
                spaces = 28 - prop.length();
                do {
                    prop.append(' ');
                } while (--spaces >= 0);
                prop.append("- ").append((CharSequence)optionalProps.get(argName));
                ctx.printLine(prop.toString());
            }
        }
    }

    protected void printNodeDescription(CommandContext ctx) throws CommandFormatException {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("\nSYNOPSIS\n\n");
        buf.append(this.commandName).append(" --help [--properties | --commands] |\n");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            for (i = 0; i <= this.commandName.length(); ++i) {
                buf.append(' ');
            }
            buf.append("--profile=<profile_name>\n");
        }
        for (i = 0; i <= this.commandName.length(); ++i) {
            buf.append(' ');
        }
        buf.append('(').append(this.name.getFullName()).append("=<resource_id> (--<property>=<value>)*) |\n");
        for (i = 0; i <= this.commandName.length(); ++i) {
            buf.append(' ');
        }
        buf.append("(<command> ").append(this.name.getFullName()).append("=<resource_id> (--<parameter>=<value>)*)");
        buf.append('\n');
        for (i = 0; i <= this.commandName.length(); ++i) {
            buf.append(' ');
        }
        buf.append("[--headers={<operation_header> (;<operation_header>)*}]");
        buf.append("\n\nDESCRIPTION\n\n");
        buf.append("The command is used to manage resources of type " + this.nodeType + ".");
        buf.append("\n\nRESOURCE DESCRIPTION\n\n");
        if (this.isDependsOnProfile() && ctx.isDomainMode() && this.profile.getValue(ctx.getParsedCommandLine()) == null) {
            buf.append("(Execute '");
            buf.append(this.commandName).append(" --profile=<profile_name> --help' to include the resource description here.)");
        } else {
            ModelNode request = this.initRequest(ctx);
            if (request == null) {
                return;
            }
            request.get("operation").set("read-resource-description");
            ModelNode result = null;
            try {
                result = ctx.getModelControllerClient().execute(request);
                if (!result.hasDefined("result")) {
                    throw new CommandFormatException("Node description is not available.");
                }
                if (!(result = result.get("result")).hasDefined("description")) {
                    throw new CommandFormatException("Node description is not available.");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (result != null) {
                buf.append(result.get("description").asString());
            } else {
                buf.append("N/A. Please, open a jira issue at https://issues.jboss.org/browse/AS7 to get this fixed. Thanks!");
            }
        }
        buf.append("\n\nARGUMENTS\n");
        buf.append("\n--help                - prints this content.");
        buf.append("\n--help --properties   - prints the list of the resource properties including their access-type");
        buf.append("\n                        (read/write/metric), value type, and the description.");
        buf.append("\n--help --commands     - prints the list of the commands available for the resource.");
        buf.append("\n                        To get the complete description of a specific command (including its parameters,");
        buf.append("\n                        their types and descriptions), execute ").append(this.commandName).append(" <command> --help.");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            buf.append("\n\n--profile    - the name of the profile the target resource belongs to.");
        }
        buf.append("\n\n").append(this.name.getFullName()).append("   - ");
        if (this.idProperty == null) {
            buf.append("is the name of the resource that completes the path ").append(this.nodeType).append(" and \n");
        } else {
            buf.append("corresponds to a property of the resource which \n");
        }
        for (i = 0; i < this.name.getFullName().length() + 5; ++i) {
            buf.append(' ');
        }
        buf.append("is used to identify the resource against which the command should be executed.");
        buf.append("\n\n<property>   - property name of the resource whose value should be updated.");
        buf.append("\n               For a complete list of available property names, their types and descriptions,");
        buf.append("\n               execute ").append(this.commandName).append(" --help --properties.");
        buf.append("\n\n<command>    - command name provided by the resource. For a complete list of available commands,");
        buf.append("\n               execute ").append(this.commandName).append(" --help --commands.");
        buf.append("\n\n<parameter>  - parameter name of the <command> provided by the resource.");
        buf.append("\n               For a complete list of available parameter names of a specific <command>,");
        buf.append("\n               their types and descriptions, execute ").append(this.commandName).append(" <command> --help.");
        buf.append("\n\n--headers    - a list of operation headers separated by a semicolon. For the list of supported");
        buf.append("\n               headers, please, refer to the domain management documentation or use tab-completion.");
        ctx.printLine(buf.toString());
    }

    protected void printSupportedCommands(CommandContext ctx) throws CommandLineException {
        List<String> list = this.getSupportedCommands(ctx);
        list.add("To read the description of a specific command execute '" + this.commandName + " command_name --help'.");
        for (String name : list) {
            ctx.printLine(name);
        }
    }

    protected List<String> getSupportedCommands(CommandContext ctx) throws CommandLineException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        request.get("operation").set("read-operation-names");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to load a list of commands.", e);
        }
        if (!result.hasDefined("result")) {
            throw new CommandLineException("Operation names aren't available.");
        }
        List nodeList = result.get("result").asList();
        ArrayList<String> supportedCommands = new ArrayList<String>(nodeList.size());
        if (!nodeList.isEmpty()) {
            for (ModelNode node : nodeList) {
                String opName = node.asString();
                if (this.excludedOps.contains(opName) || this.customHandlers != null && this.customHandlers.containsKey(opName)) continue;
                supportedCommands.add(opName);
            }
        }
        if (this.customHandlers != null) {
            supportedCommands.addAll(this.customHandlers.keySet());
        }
        Collections.sort(supportedCommands);
        return supportedCommands;
    }

    protected List<Property> getNodeProperties(CommandContext ctx) throws CommandFormatException {
        ModelNode result;
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return Collections.emptyList();
        }
        request.get("operation").set("read-resource-description");
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        if (!result.hasDefined("result")) {
            return Collections.emptyList();
        }
        if (!(result = result.get("result")).hasDefined("attributes")) {
            return Collections.emptyList();
        }
        return result.get("attributes").asPropertyList();
    }

    protected ModelNode getOperationDescription(CommandContext ctx, String operationName) throws CommandLineException {
        ModelNode result;
        OperationCommandWithDescription handler;
        if (this.customHandlers != null && (handler = this.customHandlers.get(operationName)) != null) {
            return handler.getOperationDescription(ctx);
        }
        ModelNode request = this.initRequest(ctx);
        if (request == null) {
            return null;
        }
        request.get("operation").set("read-operation-description");
        request.get("name").set(operationName);
        try {
            result = ctx.getModelControllerClient().execute(request);
        }
        catch (IOException e) {
            throw new CommandFormatException("Failed to execute read-operation-description.", e);
        }
        if (!result.hasDefined("result")) {
            return null;
        }
        return result.get("result");
    }

    protected ModelNode initRequest(CommandContext ctx) throws CommandFormatException {
        ModelNode request = new ModelNode();
        ModelNode address = request.get("address");
        if (this.isDependsOnProfile() && ctx.isDomainMode()) {
            String profileName = this.profile.getValue(ctx.getParsedCommandLine());
            if (profileName == null) {
                throw new CommandFormatException("WARNING: --profile argument is required for the complete description.");
            }
            address.add("profile", profileName);
        }
        for (OperationRequestAddress.Node node : this.getRequiredAddress()) {
            address.add(node.getType(), node.getName());
        }
        address.add(this.getRequiredType(), "?");
        return request;
    }

    class OpHandler
    extends ActionHandler {
        private final String opName;

        OpHandler(String opName) {
            if (opName == null || opName.isEmpty()) {
                throw new IllegalArgumentException("Operation name must a be non-null non-empty string.");
            }
            this.opName = opName;
        }

        @Override
        public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
            ParsedCommandLine parsedArgs = ctx.getParsedCommandLine();
            ModelNode request = new ModelNode();
            ModelNode address = request.get("address");
            if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                String profile = GenericTypeOperationHandler.this.profile.getValue(parsedArgs);
                if (profile == null) {
                    throw new OperationFormatException("Required argument --profile is missing.");
                }
                address.add("profile", profile);
            }
            String name = GenericTypeOperationHandler.this.name.getValue(ctx.getParsedCommandLine(), true);
            for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                address.add(node.getType(), node.getName());
            }
            address.add(GenericTypeOperationHandler.this.getRequiredType(), name);
            request.get("operation").set(this.opName);
            for (String argName : parsedArgs.getPropertyNames()) {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && argName.equals("--profile")) continue;
                if (this.args.isEmpty()) {
                    if (argName.equals(GenericTypeOperationHandler.this.name.getFullName())) continue;
                    throw new CommandFormatException("Command '" + GenericTypeOperationHandler.this.operation + "' is not expected to have arguments other than " + GenericTypeOperationHandler.this.name.getFullName() + ".");
                }
                ArgumentWithValue arg = (ArgumentWithValue)this.args.get(argName);
                if (arg == null) {
                    if (argName.equals(GenericTypeOperationHandler.this.name.getFullName())) continue;
                    throw new CommandFormatException("Unrecognized argument " + argName + " for command '" + this.opName + "'.");
                }
                String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
                String valueString = parsedArgs.getPropertyValue(argName);
                ModelNode nodeValue = arg.getValueConverter().fromString(valueString);
                request.get(propName).set(nodeValue);
            }
            return request;
        }
    }

    private class WritePropertyHandler
    extends ActionHandler {
        private WritePropertyHandler() {
        }

        @Override
        public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
            String profile;
            String name = GenericTypeOperationHandler.this.name.getValue(ctx.getParsedCommandLine(), true);
            ModelNode composite = new ModelNode();
            composite.get("operation").set("composite");
            composite.get("address").setEmptyList();
            ModelNode steps = composite.get("steps");
            ParsedCommandLine args = ctx.getParsedCommandLine();
            if (GenericTypeOperationHandler.this.isDependsOnProfile() && ctx.isDomainMode()) {
                profile = GenericTypeOperationHandler.this.profile.getValue(args);
                if (profile == null) {
                    throw new OperationFormatException("--profile argument value is missing.");
                }
            } else {
                profile = null;
            }
            Map nodeProps = this.args;
            for (String argName : args.getPropertyNames()) {
                if (GenericTypeOperationHandler.this.isDependsOnProfile() && argName.equals("--profile") || GenericTypeOperationHandler.this.name.getFullName().equals(argName)) continue;
                ArgumentWithValue arg = (ArgumentWithValue)nodeProps.get(argName);
                if (arg == null) {
                    throw new CommandFormatException("Unrecognized argument name '" + argName + "'");
                }
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                if (profile != null) {
                    builder.addNode("profile", profile);
                }
                for (OperationRequestAddress.Node node : GenericTypeOperationHandler.this.getRequiredAddress()) {
                    builder.addNode(node.getType(), node.getName());
                }
                builder.addNode(GenericTypeOperationHandler.this.getRequiredType(), name);
                builder.setOperationName("write-attribute");
                String propName = argName.charAt(1) == '-' ? argName.substring(2) : argName.substring(1);
                builder.addProperty("name", propName);
                String valueString = args.getPropertyValue(argName);
                ModelNode nodeValue = arg.getValueConverter().fromString(valueString);
                builder.getModelNode().get("value").set(nodeValue);
                steps.add(builder.buildRequest());
            }
            return composite;
        }
    }

    private abstract class ActionHandler
    implements CommandHandler,
    OperationCommand {
        protected Map<String, CommandArgument> args = Collections.emptyMap();

        private ActionHandler() {
        }

        void addArgument(CommandArgument arg) {
            if (arg == null) {
                throw new IllegalArgumentException("Argument can't be null.");
            }
            if (this.args.isEmpty()) {
                this.args = new HashMap<String, CommandArgument>();
            }
            this.args.put(arg.getFullName(), arg);
        }

        @Override
        public boolean isAvailable(CommandContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isBatchMode(CommandContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void handle(CommandContext ctx) throws CommandLineException {
            throw new UnsupportedOperationException();
        }

        @Override
        public CommandArgument getArgument(CommandContext ctx, String name) {
            return this.args.get(name);
        }

        @Override
        public boolean hasArgument(CommandContext ctx, String name) {
            return this.args.containsKey(name);
        }

        @Override
        public boolean hasArgument(CommandContext ctx, int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<CommandArgument> getArguments(CommandContext ctx) {
            return this.args.values();
        }
    }
}

