/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Random;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ArchiveHandler
extends BatchModeCommandHandler {
    private final ArgumentWithoutValue path;
    private final ArgumentWithValue script;
    private final Random rng = new Random();

    public ArchiveHandler(CommandContext ctx) {
        super(ctx, "archive", true);
        final FilenameTabCompleter pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        this.path = new ArgumentWithValue(this, pathCompleter, 0, "--path"){

            @Override
            public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
                String value = super.getValue(args, required);
                if (value != null) {
                    if (value.length() >= 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    value = pathCompleter.translatePath(value);
                }
                return value;
            }
        };
        this.script = new ArgumentWithValue(this, "--script");
        this.path.addCantAppearAfter(this.script);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        File root;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        String path = this.path.getValue(args, true);
        File archive = new File(path);
        if (!archive.exists()) {
            throw new OperationFormatException("Path " + archive.getAbsolutePath() + " doesn't exist.");
        }
        if (archive.isDirectory()) {
            throw new OperationFormatException(archive.getAbsolutePath() + " is a directory.");
        }
        try {
            root = this.extractArchive(archive);
        }
        catch (IOException e) {
            throw new OperationFormatException("Unable to extract archive '" + archive.getAbsolutePath() + "' to temporary location");
        }
        ctx.setCurrentDir(root);
        String holdbackBatch = this.activateNewBatch(ctx);
        try {
            ModelNode composite;
            File scriptFile;
            String script = this.script.getValue(args);
            if (script == null) {
                script = "deploy.scr";
            }
            if (!(scriptFile = new File(ctx.getCurrentDir(), script)).exists()) {
                throw new CommandFormatException("ERROR: script " + script + "' not found.");
            }
            ctx.printLine("Processing script '" + script + "'.");
            try {
                BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
                String line = reader.readLine();
                while (!ctx.isTerminated() && line != null) {
                    ctx.handle(line);
                    line = reader.readLine();
                }
            }
            catch (FileNotFoundException e) {
                throw new CommandFormatException("ERROR: script " + script + "' not found.");
            }
            catch (IOException e) {
                throw new CommandFormatException(e.getMessage());
            }
            catch (CommandLineException e) {
                throw new CommandFormatException(e.getMessage());
            }
            ModelNode modelNode = composite = ctx.getBatchManager().getActiveBatch().toRequest();
            return modelNode;
        }
        finally {
            ctx.setCurrentDir(new File(""));
            this.discardBatch(ctx, holdbackBatch);
            this.recursiveDelete(root);
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException e1) {
            ctx.error(e1.getLocalizedMessage());
            return;
        }
        if (request == null) {
            ctx.error("Operation request wasn't built.");
            return;
        }
        try {
            ModelNode result = ctx.getModelControllerClient().execute(request);
            if (Util.isSuccess(result)) {
                ctx.printLine("The archive script executed successfully.");
            } else {
                ctx.error("Failed to execute archive script: " + Util.getFailureDescription(result));
            }
        }
        catch (Exception e) {
            ctx.error("Failed to execute archive script: " + e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File extractArchive(File archive) throws IOException {
        File systemTmpDir = new File(System.getProperty("java.io.tmpdir"));
        File tempDir = new File(systemTmpDir, "cli-" + Long.toHexString(this.rng.nextLong()));
        tempDir.mkdir();
        JarFile jarFile = new JarFile(archive);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            File file = new File(tempDir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdir();
                continue;
            }
            InputStream is = null;
            FileOutputStream fos = null;
            try {
                int rc;
                int bufferSize = 65536;
                byte[] buf = new byte[bufferSize];
                is = jarFile.getInputStream(entry);
                fos = new FileOutputStream(file);
                while ((rc = is.read(buf)) > -1) {
                    fos.write(buf, 0, rc);
                }
                fos.flush();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(is);
                StreamUtils.safeClose(fos);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)is);
            StreamUtils.safeClose((Closeable)fos);
        }
        return tempDir;
    }

    private String activateNewBatch(CommandContext ctx) {
        String currentBatch = null;
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.isBatchActive()) {
            currentBatch = "batch" + System.currentTimeMillis();
            batchManager.holdbackActiveBatch(currentBatch);
        }
        batchManager.activateNewBatch();
        return currentBatch;
    }

    private void discardBatch(CommandContext ctx, String holdbackBatch) {
        BatchManager batchManager = ctx.getBatchManager();
        batchManager.discardActiveBatch();
        if (holdbackBatch != null) {
            batchManager.activateHeldbackBatch(holdbackBatch);
        }
    }

    private void recursiveDelete(File root) {
        if (root.isDirectory()) {
            File[] files;
            for (File file : files = root.listFiles()) {
                this.recursiveDelete(file);
            }
        } else {
            root.delete();
        }
    }
}

