/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.gui.CommandExecutor;
import org.jboss.as.cli.gui.DoOperationActionListener;
import org.jboss.as.cli.gui.ManagementModel;
import org.jboss.as.cli.gui.SelectPreviousOpMouseAdapter;

public class GuiMain {
    private static final String SUBMIT_ACTION = "submit-action";
    private static JFrame frame;
    private static JTextField cmdText;
    private static CommandExecutor executor;
    private static Container contentPane;
    private static JPanel mainPanel;
    private static JButton submitButton;
    private static JTextPane output;
    private static JTabbedPane tabs;
    private static DoOperationActionListener opListener;

    private GuiMain() {
    }

    public static synchronized void start(CommandContext cmdCtx) {
        if (executor != null) {
            throw new RuntimeException("Gui is already initialized.");
        }
        executor = new CommandExecutor(cmdCtx);
        ToolTipManager.sharedInstance().setDismissDelay(15000);
        GuiMain.initJFrame();
    }

    public static JFrame getFrame() {
        return frame;
    }

    public static JTextField getCommandText() {
        return cmdText;
    }

    public static CommandExecutor getExecutor() {
        return executor;
    }

    private static synchronized void initJFrame() {
        frame = new JFrame("CLI GUI");
        URL iconURL = GuiMain.class.getResource("/icon/as7_logo.png");
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage(iconURL));
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setSize(800, 600);
        contentPane = frame.getContentPane();
        mainPanel.setBorder(BorderFactory.createEtchedBorder());
        contentPane.add((Component)mainPanel, "Center");
        mainPanel.setLayout(new BorderLayout(5, 5));
        tabs = GuiMain.makeTabbedPane();
        opListener = new DoOperationActionListener(output, tabs);
        output.addMouseListener(new SelectPreviousOpMouseAdapter(output, cmdText, opListener));
        mainPanel.add((Component)GuiMain.makeCommandLine(), "North");
        mainPanel.add((Component)tabs, "Center");
        frame.setVisible(true);
    }

    private static JTabbedPane makeTabbedPane() {
        JTabbedPane tabs = new JTabbedPane();
        tabs.addTab("Command Builder", new JScrollPane(new ManagementModel()));
        tabs.addTab("Output", GuiMain.makeOutputDisplay());
        return tabs;
    }

    private static JPanel makeCommandLine() {
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BorderLayout(2, 5));
        cmdLine.add((Component)new JLabel("cmd>"), "West");
        cmdText.setText("/");
        cmdLine.add((Component)cmdText, "Center");
        KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0, true);
        cmdText.getInputMap().put(enterKey, SUBMIT_ACTION);
        cmdText.getActionMap().put(SUBMIT_ACTION, opListener);
        submitButton.addActionListener(opListener);
        cmdLine.add((Component)submitButton, "East");
        return cmdLine;
    }

    private static JPanel makeOutputDisplay() {
        JPanel outputDisplay = new JPanel();
        outputDisplay.setSize(400, 5000);
        outputDisplay.setLayout(new BorderLayout(5, 5));
        output.setEditable(false);
        outputDisplay.add((Component)new JScrollPane(output), "Center");
        return outputDisplay;
    }

    static {
        cmdText = new JTextField();
        mainPanel = new JPanel();
        submitButton = new JButton("Submit");
        output = new JTextPane();
    }
}

