/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineFormat;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.parsing.InitialState;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.StateParser;
import org.jboss.as.cli.parsing.command.ArgumentListState;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.cli.parsing.operation.OperationFormat;
import org.jboss.as.cli.parsing.operation.OperationRequestState;

public class ParserUtil {
    public static void parse(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        StateParser.parse(commandLine, callbackHandler, InitialState.INSTANCE);
    }

    public static void parseOperationRequest(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        StateParser.parse(commandLine, callbackHandler, OperationRequestState.INSTANCE);
    }

    public static void parseCommandArgs(String commandLine, CommandLineParser.CallbackHandler handler) throws CommandFormatException {
        if (commandLine == null) {
            return;
        }
        ParsingStateCallbackHandler callbackHandler = ParserUtil.getCallbackHandler(handler);
        StateParser.parse(commandLine, callbackHandler, ArgumentListState.INSTANCE);
    }

    protected static ParsingStateCallbackHandler getCallbackHandler(final CommandLineParser.CallbackHandler handler) {
        return new ParsingStateCallbackHandler(){
            private int nameValueSeparator = -1;
            private String name;
            final StringBuilder buffer = new StringBuilder();
            int bufferStartIndex = 0;
            boolean inValue;

            @Override
            public void enteredState(ParsingContext ctx) throws OperationFormatException {
                String id = ctx.getState().getId();
                if (!this.inValue) {
                    this.bufferStartIndex = ctx.getLocation();
                }
                if (id.equals("PROP_LIST")) {
                    handler.propertyListStart(ctx.getLocation());
                } else if ("PROP_VALUE".equals(id)) {
                    this.inValue = true;
                } else if ("ADDR_OP_SEP".equals(id)) {
                    handler.addressOperationSeparator(ctx.getLocation());
                } else if ("NODE".equals(id)) {
                    this.inValue = true;
                } else if ("NAME_VALUE_SEPARATOR".equals(id)) {
                    this.nameValueSeparator = ctx.getLocation();
                    if (this.buffer.length() > 0) {
                        this.name = this.buffer.toString().trim();
                        this.buffer.setLength(0);
                    }
                } else if (id.equals("CMD")) {
                    handler.setFormat(CommandFormat.INSTANCE);
                } else if (id.equals("OP_REQ")) {
                    handler.setFormat(OperationFormat.INSTANCE);
                }
            }

            @Override
            public void leavingState(ParsingContext ctx) throws CommandFormatException {
                String id = ctx.getState().getId();
                if (id.equals("PROP_LIST")) {
                    if (!ctx.isEndOfContent()) {
                        handler.propertyListEnd(ctx.getLocation());
                    }
                } else if ("PROP".equals(id)) {
                    if (this.name != null) {
                        String value = this.buffer.toString().trim();
                        if (value.length() > 0) {
                            handler.property(this.name, value, this.bufferStartIndex);
                        } else {
                            handler.propertyName(this.bufferStartIndex, this.name);
                            if (this.nameValueSeparator != -1) {
                                handler.propertyNameValueSeparator(this.nameValueSeparator);
                            }
                        }
                    } else {
                        handler.propertyName(this.bufferStartIndex, this.buffer.toString().trim());
                        if (this.nameValueSeparator != -1) {
                            handler.propertyNameValueSeparator(this.nameValueSeparator);
                        }
                    }
                    if (!ctx.isEndOfContent()) {
                        handler.propertySeparator(ctx.getLocation());
                    }
                    this.buffer.setLength(0);
                    this.name = null;
                    this.nameValueSeparator = -1;
                } else if ("PROP_VALUE".equals(id)) {
                    if (this.name == null) {
                        handler.property(null, this.buffer.toString().trim(), this.bufferStartIndex);
                        this.buffer.setLength(0);
                        if (!ctx.isEndOfContent()) {
                            handler.propertySeparator(ctx.getLocation());
                        }
                    }
                    this.inValue = false;
                } else if ("OP_NAME".equals(id)) {
                    String opName = this.buffer.toString().trim();
                    if (!opName.isEmpty()) {
                        handler.operationName(this.bufferStartIndex, opName);
                    }
                    this.buffer.setLength(0);
                } else if ("NODE".equals(id)) {
                    char ch = ctx.getCharacter();
                    if (this.buffer.length() == 0) {
                        if (ch == '/') {
                            handler.rootNode(this.bufferStartIndex);
                            handler.nodeSeparator(ctx.getLocation());
                        }
                    } else {
                        String value = this.buffer.toString().trim();
                        if (ch == '=') {
                            handler.nodeType(this.bufferStartIndex, value);
                            handler.nodeTypeNameSeparator(ctx.getLocation());
                        } else if (ch == ':') {
                            handler.nodeName(this.bufferStartIndex, value);
                        } else {
                            if (!".".equals(value)) {
                                if ("..".equals(value)) {
                                    handler.parentNode(ctx.getLocation() - 2);
                                } else if (".type".equals(value)) {
                                    handler.nodeType(ctx.getLocation() - 5);
                                } else if (ch == '/') {
                                    if ("".equals(value)) {
                                        handler.rootNode(ctx.getLocation());
                                    } else {
                                        handler.nodeName(this.bufferStartIndex, value);
                                    }
                                } else {
                                    handler.nodeTypeOrName(this.bufferStartIndex, value);
                                }
                            }
                            if (ch == '/') {
                                handler.nodeSeparator(ctx.getLocation());
                            }
                        }
                    }
                    this.buffer.setLength(0);
                    this.inValue = false;
                } else if ("OUT_REDIRECT".equals(id)) {
                    handler.outputTarget(this.bufferStartIndex, this.buffer.toString().trim());
                    this.buffer.setLength(0);
                }
            }

            @Override
            public void character(ParsingContext ctx) throws OperationFormatException {
                this.buffer.append(ctx.getCharacter());
            }
        };
    }

    public static void main(String[] args) throws Exception {
        String line = "s";
        System.out.println("s");
        ParserUtil.parse("s", new CommandLineParser.CallbackHandler(){

            @Override
            public void property(String name, String value, int separator) {
                StringBuilder buf = new StringBuilder();
                if (name == null) {
                    buf.append('\'').append(value).append('\'');
                } else if (value == null) {
                    buf.append('\'').append(name).append('\'');
                } else {
                    buf.append('\'').append(name).append("'='").append(value).append('\'');
                }
                System.out.println(buf.toString());
            }

            @Override
            public void operationName(int index, String name) throws CommandFormatException {
                System.out.println("command: '" + name + "'");
            }

            @Override
            public void outputTarget(int index, String outputTarget) throws CommandFormatException {
                System.out.println("output: '" + outputTarget + "'");
            }

            @Override
            public void start(String operationString) {
            }

            @Override
            public void rootNode(int index) {
                System.out.println("rootNode " + index);
            }

            @Override
            public void parentNode(int index) {
                System.out.println("parentNode");
            }

            @Override
            public void nodeType(int index) {
                System.out.println("nodeType");
            }

            @Override
            public void nodeType(int index, String nodeType) throws OperationFormatException {
                System.out.println("nodeType: '" + nodeType + "'");
            }

            @Override
            public void nodeTypeNameSeparator(int index) {
            }

            @Override
            public void nodeName(int index, String nodeName) throws OperationFormatException {
                System.out.println("nodeName: '" + nodeName + "'");
            }

            @Override
            public void nodeSeparator(int index) {
            }

            @Override
            public void addressOperationSeparator(int index) {
            }

            @Override
            public void propertyListStart(int index) {
            }

            @Override
            public void propertyName(int index, String propertyName) throws OperationFormatException {
                System.out.println("propertyName: " + propertyName);
            }

            @Override
            public void propertyNameValueSeparator(int index) {
            }

            @Override
            public void propertySeparator(int index) {
            }

            @Override
            public void propertyListEnd(int index) {
            }

            @Override
            public void nodeTypeOrName(int index, String typeOrName) throws OperationFormatException {
            }

            @Override
            public void setFormat(CommandLineFormat format) {
            }
        });
    }
}

