/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.regex.Pattern;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.OperationFormatException;

public abstract class ValidatingCallbackHandler
implements CommandLineParser.CallbackHandler {
    private static final Pattern ALPHANUMERICS_PATTERN = Pattern.compile("[_a-zA-Z](?:[-_a-zA-Z0-9]*[_a-zA-Z0-9])?");
    private static final Pattern NODE_NAME_PATTERN = Pattern.compile("\\*|[^*\\p{Space}\\p{Cntrl}]+");
    protected String operationStr;

    @Override
    public void start(String operationString) {
        this.operationStr = operationString;
    }

    @Override
    public void nodeType(int index, String nodeType) throws OperationFormatException {
        this.assertValidType(nodeType);
        this.validatedNodeType(index, nodeType);
    }

    protected abstract void validatedNodeType(int var1, String var2) throws OperationFormatException;

    @Override
    public void nodeName(int index, String nodeName) throws OperationFormatException {
        this.assertValidNodeName(nodeName);
        this.validatedNodeName(index, nodeName);
    }

    protected abstract void validatedNodeName(int var1, String var2) throws OperationFormatException;

    @Override
    public void operationName(int index, String operationName) throws OperationFormatException {
        if (operationName == null || !ALPHANUMERICS_PATTERN.matcher(operationName).matches()) {
            throw new OperationFormatException("'" + operationName + "' is not a valid operation name.");
        }
        this.validatedOperationName(index, operationName);
    }

    protected abstract void validatedOperationName(int var1, String var2) throws OperationFormatException;

    @Override
    public void propertyName(int index, String propertyName) throws OperationFormatException {
        this.assertValidParameterName(propertyName);
        this.validatedPropertyName(index, propertyName);
    }

    protected abstract void validatedPropertyName(int var1, String var2) throws OperationFormatException;

    @Override
    public void property(String name, String value, int nameValueSeparatorIndex) throws OperationFormatException {
        this.assertValidParameterName(name);
        if (value.isEmpty()) {
            throw new OperationFormatException("Parameter '" + value + "' is missing value.");
        }
        this.validatedProperty(name, value, nameValueSeparatorIndex);
    }

    protected abstract void validatedProperty(String var1, String var2, int var3) throws OperationFormatException;

    protected void assertValidType(String nodeType) throws OperationFormatException {
        if (nodeType == null || !ALPHANUMERICS_PATTERN.matcher(nodeType).matches()) {
            throw new OperationFormatException("'" + nodeType + "' is not a valid node type name.");
        }
    }

    protected void assertValidNodeName(String nodeName) throws OperationFormatException {
        if (nodeName == null || !NODE_NAME_PATTERN.matcher(nodeName).matches()) {
            throw new OperationFormatException("'" + nodeName + "' is not a valid node name.");
        }
    }

    protected void assertValidParameterName(String name) throws OperationFormatException {
        if (name == null || !ALPHANUMERICS_PATTERN.matcher(name).matches()) {
            throw new OperationFormatException("'" + name + "' is not a valid parameter name.");
        }
    }
}

