/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;

public class CommandCandidatesProvider
implements OperationCandidatesProvider {
    private final CommandRegistry registry;

    public CommandCandidatesProvider(CommandRegistry registry) {
        if (registry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.registry = registry;
    }

    @Override
    public List<String> getNodeNames(CommandContext ctx, OperationRequestAddress prefix) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getNodeTypes(CommandContext ctx, OperationRequestAddress prefix) {
        return Collections.emptyList();
    }

    @Override
    public List<String> getOperationNames(CommandContext ctx, OperationRequestAddress prefix) {
        ArrayList<String> commands = new ArrayList<String>();
        for (String command : this.registry.getTabCompletionCommands()) {
            CommandHandler handler = this.registry.getCommandHandler(command);
            if (!handler.isAvailable(ctx)) continue;
            commands.add(command);
        }
        return commands;
    }

    @Override
    public List<CommandArgument> getProperties(CommandContext ctx, String operationName, OperationRequestAddress address) {
        CommandHandler handler = this.registry.getCommandHandler(operationName);
        if (handler == null) {
            return Collections.emptyList();
        }
        return handler.getArguments(ctx);
    }
}

