/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.List;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class ArgumentWithValue
extends ArgumentWithoutValue {
    private final CommandLineCompleter valueCompleter;

    public ArgumentWithValue(CommandHandlerWithArguments handler, String fullName) {
        this(handler, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, String fullName) {
        this(handler, valueCompleter, fullName, null);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, String fullName, String shortName) {
        this(handler, null, fullName, shortName);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, int index, String fullName) {
        this(handler, null, index, fullName);
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, int index, String fullName) {
        super(handler, index, fullName);
        this.valueCompleter = valueCompleter;
    }

    public ArgumentWithValue(CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter, String fullName, String shortName) {
        super(handler, fullName, shortName);
        this.valueCompleter = valueCompleter;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return this.valueCompleter;
    }

    @Override
    public String getValue(ParsedArguments args, boolean required) throws CommandFormatException {
        String value = null;
        if (args.hasArguments()) {
            List<String> others;
            if (this.index >= 0 && (others = args.getOtherArguments()).size() > this.index) {
                return others.get(this.index);
            }
            value = args.getArgument(this.fullName);
            if (value == null && this.shortName != null) {
                value = args.getArgument(this.shortName);
            }
        }
        if (required && value == null && !this.isPresent(args)) {
            StringBuilder buf = new StringBuilder();
            buf.append("Required argument ");
            buf.append('\'').append(this.fullName).append('\'');
            buf.append(" is missing.");
            throw new CommandFormatException(buf.toString());
        }
        return value;
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }
}

