/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;

public class BatchEditLineHandler
extends CommandHandlerWithHelp {
    private final CommandLineCompleter argCompleter = new CommandLineCompleter(){

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            int lineNumber;
            int nextWsIndex;
            int nextCharIndex;
            BatchManager batchManager = ctx.getBatchManager();
            if (!batchManager.isBatchActive()) {
                return -1;
            }
            for (nextCharIndex = 0; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
            }
            if (nextCharIndex == buffer.length()) {
                candidates.add("--help");
                return nextCharIndex;
            }
            for (nextWsIndex = nextCharIndex + 1; nextWsIndex < buffer.length() && !Character.isWhitespace(buffer.charAt(nextWsIndex)); ++nextWsIndex) {
            }
            if (nextWsIndex == buffer.length()) {
                return -1;
            }
            String lineNumberStr = buffer.substring(nextCharIndex, nextWsIndex);
            if ("--help".startsWith(lineNumberStr)) {
                candidates.add("--help");
                return nextCharIndex;
            }
            try {
                lineNumber = Integer.parseInt(lineNumberStr);
            }
            catch (NumberFormatException e) {
                return -1;
            }
            Batch batch = batchManager.getActiveBatch();
            int batchSize = batch.size();
            if (lineNumber < 1 || lineNumber > batchSize) {
                return -1;
            }
            for (nextCharIndex = nextWsIndex + 1; nextCharIndex < buffer.length() && Character.isWhitespace(buffer.charAt(nextCharIndex)); ++nextCharIndex) {
            }
            String cmd = buffer.substring(nextCharIndex);
            if ("--help".startsWith(cmd)) {
                candidates.add("--help");
            }
            int cmdResult = ctx.getDefaultCommandCompleter().complete(ctx, cmd, 0, candidates);
            String batchedCmd = batch.getCommands().get(lineNumber - 1).getCommand();
            if (cmd.isEmpty() || batchedCmd.startsWith(cmd)) {
                if (cmdResult > -1) {
                    candidates.add(batchedCmd.substring(cmdResult).trim());
                } else {
                    candidates.add(batchedCmd);
                }
            }
            if (cmdResult < 0) {
                return candidates.isEmpty() ? -1 : nextCharIndex;
            }
            return nextCharIndex + cmdResult;
        }
    };

    public BatchEditLineHandler() {
        super("batch-edit-line");
    }

    @Override
    public CommandLineCompleter getArgumentCompleter() {
        return this.argCompleter;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        int lineNumber;
        int i;
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            ctx.printLine("No active batch.");
            return;
        }
        Batch batch = batchManager.getActiveBatch();
        int batchSize = batch.size();
        if (batchSize == 0) {
            ctx.printLine("The batch is empty.");
            return;
        }
        String argsStr = ctx.getArgumentsString();
        if (argsStr == null) {
            ctx.printLine("Missing line number.");
            return;
        }
        for (i = 0; i < argsStr.length() && !Character.isWhitespace(argsStr.charAt(i)); ++i) {
        }
        if (i == argsStr.length()) {
            ctx.printLine("Missing the new command line after the index.");
            return;
        }
        String intStr = argsStr.substring(0, i);
        try {
            lineNumber = Integer.parseInt(intStr);
        }
        catch (NumberFormatException e) {
            ctx.printLine("Failed to parse line number '" + intStr + "': " + e.getLocalizedMessage());
            return;
        }
        if (lineNumber < 1 || lineNumber > batchSize) {
            ctx.printLine(lineNumber + " isn't in range [1.." + batchSize + "].");
            return;
        }
        String editedLine = argsStr.substring(i).trim();
        if (editedLine.length() == 0) {
            ctx.printLine("Missing the new command line after the index.");
            return;
        }
        try {
            BatchedCommand newCmd = ctx.toBatchedCommand(editedLine);
            batch.set(lineNumber - 1, newCmd);
            ctx.printLine("#" + lineNumber + " " + newCmd.getCommand());
        }
        catch (CommandFormatException e) {
            ctx.printLine("Failed to process command line '" + editedLine + "': " + e.getLocalizedMessage());
        }
    }

    @Override
    public boolean hasArgument(int index) {
        return true;
    }

    @Override
    public boolean hasArgument(String name) {
        return true;
    }
}

