/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;

public class LsHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithValue nodePath;
    private final ArgumentWithoutValue l = new ArgumentWithoutValue(this, "-l");

    public LsHandler() {
        this("ls");
    }

    public LsHandler(String command) {
        super(command, true);
        this.nodePath = new ArgumentWithValue((CommandHandlerWithArguments)this, (CommandLineCompleter)OperationRequestCompleter.INSTANCE, 0, "--node-path");
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        List<String> names;
        DefaultOperationRequestAddress address;
        String nodePath = this.nodePath.getValue(ctx.getParsedArguments());
        if (nodePath != null) {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
            DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(address);
            try {
                ctx.getOperationRequestParser().parse(nodePath, handler);
            }
            catch (CommandFormatException e) {
                ctx.printLine(e.getLocalizedMessage());
            }
        } else {
            address = new DefaultOperationRequestAddress(ctx.getPrefix());
        }
        if (address.endsOnType()) {
            String type = address.getNodeType();
            address.toParentNode();
            names = Util.getNodeNames(ctx.getModelControllerClient(), address, type);
        } else {
            names = Util.getNodeTypes(ctx.getModelControllerClient(), address);
        }
        this.printList(ctx, names, this.l.isPresent(ctx.getParsedArguments()));
    }
}

