/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.impl.ArgumentWithoutValue;

public class HistoryHandler
extends CommandHandlerWithHelp {
    private final ArgumentWithoutValue clear = new ArgumentWithoutValue(this, "--clear");
    private final ArgumentWithoutValue disable;
    private final ArgumentWithoutValue enable;

    public HistoryHandler() {
        this("history");
    }

    public HistoryHandler(String command) {
        super(command);
        this.clear.setExclusive(true);
        this.disable = new ArgumentWithoutValue(this, "--disable");
        this.disable.setExclusive(true);
        this.enable = new ArgumentWithoutValue(this, "--enable");
        this.enable.setExclusive(true);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        ParsedArguments args = ctx.getParsedArguments();
        if (!args.hasArguments()) {
            HistoryHandler.printHistory(ctx);
            return;
        }
        if (this.clear.isPresent(args)) {
            ctx.getHistory().clear();
        } else if (this.disable.isPresent(args)) {
            ctx.getHistory().setUseHistory(false);
        } else if (this.enable.isPresent(args)) {
            ctx.getHistory().setUseHistory(true);
        } else {
            ctx.printLine("Unexpected argument '" + ctx.getArgumentsString() + '\'');
        }
    }

    private static void printHistory(CommandContext ctx) {
        CommandHistory history = ctx.getHistory();
        List<String> list = history.asList();
        for (String cmd : list) {
            ctx.printLine(cmd);
        }
        ctx.printLine("(The history is currently " + (history.isUseHistory() ? "enabled)" : "disabled)"));
    }
}

