/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.batch.impl.DefaultBatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatchedCommand;
import org.jboss.as.cli.handlers.CommandCommandHandler;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.handlers.batch.BatchClearHandler;
import org.jboss.as.cli.handlers.batch.BatchDiscardHandler;
import org.jboss.as.cli.handlers.batch.BatchEditLineHandler;
import org.jboss.as.cli.handlers.batch.BatchHandler;
import org.jboss.as.cli.handlers.batch.BatchHoldbackHandler;
import org.jboss.as.cli.handlers.batch.BatchListHandler;
import org.jboss.as.cli.handlers.batch.BatchMoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRemoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRunHandler;
import org.jboss.as.cli.handlers.jca.DataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.DataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.DataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jms.CreateJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.DeleteJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.JmsCFAddHandler;
import org.jboss.as.cli.handlers.jms.JmsCFRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueAddHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicAddHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicRemoveHandler;
import org.jboss.as.cli.impl.DefaultParsedArguments;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.PrefixFormatter;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.old.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.sasl.JBossSaslProvider;

public class CommandLineMain {
    private static final CommandRegistry cmdRegistry = new CommandRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            Security.addProvider((Provider)new JBossSaslProvider());
            String argError = null;
            String[] commands = null;
            File file = null;
            boolean connect = false;
            String defaultControllerHost = null;
            int defaultControllerPort = -1;
            boolean version = false;
            for (String arg : args) {
                String value;
                if (arg.startsWith("controller=") || arg.startsWith("--controller=")) {
                    value = arg.startsWith("--") ? arg.substring(13) : arg.substring(11);
                    String portStr = null;
                    int colonIndex = value.indexOf(58);
                    if (colonIndex < 0) {
                        defaultControllerHost = value;
                    } else if (colonIndex == 0) {
                        portStr = value.substring(1);
                    } else {
                        defaultControllerHost = value.substring(0, colonIndex);
                        portStr = value.substring(colonIndex + 1);
                    }
                    if (portStr == null) continue;
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                        if (port < 0) {
                            argError = "The port must be a valid non-negative integer: '" + args + "'";
                            continue;
                        }
                        defaultControllerPort = port;
                    }
                    catch (NumberFormatException e) {
                        argError = "The port must be a valid non-negative integer: '" + arg + "'";
                    }
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if (arg.startsWith("file=") || arg.startsWith("--file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument 'file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of 'file', 'commands' or 'command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument 'file' is missing value.";
                    break;
                }
                if (arg.startsWith("commands=") || arg.startsWith("--commands=")) {
                    if (file != null) {
                        argError = "Only one of 'file', 'commands' or 'command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument 'command'/'commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = value.split(",+");
                    continue;
                }
                if (!arg.startsWith("command=") && !arg.startsWith("--command=")) continue;
                if (file != null) {
                    argError = "Only one of 'file', 'commands' or 'command' can appear as the argument at a time.";
                    break;
                }
                if (commands != null) {
                    argError = "Duplicate argument 'command'/'commands'.";
                    break;
                }
                value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                commands = new String[]{value};
            }
            if (argError != null) {
                System.err.println(argError);
                return;
            }
            if (version) {
                CommandContextImpl cmdCtx = new CommandContextImpl();
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                CommandLineMain.processFile(file, defaultControllerHost, defaultControllerPort, connect);
                return;
            }
            if (commands != null) {
                CommandLineMain.processCommands(commands, defaultControllerHost, defaultControllerPort, connect);
                return;
            }
            ConsoleReader console = CommandLineMain.initConsoleReader();
            final CommandContextImpl cmdCtx = new CommandContextImpl(console);
            SecurityActions.addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    cmdCtx.disconnectController();
                }
            }));
            console.addCompletor((Completor)cmdCtx.cmdCompleter);
            if (defaultControllerHost != null) {
                cmdCtx.defaultControllerHost = defaultControllerHost;
            }
            if (defaultControllerPort != -1) {
                cmdCtx.defaultControllerPort = defaultControllerPort;
            }
            if (connect) {
                cmdCtx.connectController(null, -1);
            } else {
                cmdCtx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            }
            try {
                while (!cmdCtx.terminate) {
                    String line = console.readLine(cmdCtx.getPrompt());
                    if (line == null) {
                        cmdCtx.terminateSession();
                        continue;
                    }
                    CommandLineMain.processLine(cmdCtx, line.trim());
                }
            }
            finally {
                cmdCtx.disconnectController();
            }
        }
        finally {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(String[] commands, String defaultControllerHost, int defaultControllerPort, final boolean connect) {
        final CommandContextImpl cmdCtx = new CommandContextImpl();
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController(!connect);
            }
        }));
        if (defaultControllerHost != null) {
            cmdCtx.defaultControllerHost = defaultControllerHost;
        }
        if (defaultControllerPort != -1) {
            cmdCtx.defaultControllerPort = defaultControllerPort;
        }
        if (connect) {
            cmdCtx.connectController(null, -1, false);
        }
        try {
            for (int i = 0; i < commands.length && !cmdCtx.terminate; ++i) {
                CommandLineMain.processLine(cmdCtx, commands[i]);
            }
        }
        catch (Throwable throwable) {
            if (!cmdCtx.terminate) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController(!connect);
            throw throwable;
        }
        if (!cmdCtx.terminate) {
            cmdCtx.terminateSession();
        }
        cmdCtx.disconnectController(!connect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(File file, String defaultControllerHost, int defaultControllerPort, final boolean connect) {
        final CommandContextImpl cmdCtx = new CommandContextImpl();
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController(!connect);
            }
        }));
        if (defaultControllerHost != null) {
            cmdCtx.defaultControllerHost = defaultControllerHost;
        }
        if (defaultControllerPort != -1) {
            cmdCtx.defaultControllerPort = defaultControllerPort;
        }
        if (connect) {
            cmdCtx.connectController(null, -1, false);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (!cmdCtx.terminate && line != null) {
                CommandLineMain.processLine(cmdCtx, line.trim());
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            try {
                cmdCtx.printLine("Failed to process file '" + file.getAbsolutePath() + "'");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                if (!cmdCtx.terminate) {
                    cmdCtx.terminateSession();
                }
                cmdCtx.disconnectController(!connect);
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)reader);
            if (!cmdCtx.terminate) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController(!connect);
        }
        StreamUtils.safeClose((Closeable)reader);
        if (!cmdCtx.terminate) {
            cmdCtx.terminateSession();
        }
        cmdCtx.disconnectController(!connect);
    }

    protected static void processLine(CommandContextImpl cmdCtx, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (line.charAt(0) == '#') {
            return;
        }
        if (CommandLineMain.isOperation(line)) {
            cmdCtx.setArgs(null, line, null);
            if (cmdCtx.isBatchMode()) {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(cmdCtx.getPrefix());
                try {
                    cmdCtx.getOperationRequestParser().parse(line, builder);
                    ModelNode request = builder.buildRequest();
                    StringBuilder op = new StringBuilder();
                    op.append(cmdCtx.getPrefixFormatter().format(builder.getAddress()));
                    op.append(line.substring(line.indexOf(58)));
                    DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(op.toString(), request);
                    Batch batch = cmdCtx.getBatchManager().getActiveBatch();
                    batch.add(batchedCmd);
                    cmdCtx.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
                }
                catch (CommandFormatException e) {
                    cmdCtx.printLine(e.getLocalizedMessage());
                }
            } else {
                cmdCtx.operationHandler.handle(cmdCtx);
            }
        } else {
            CommandHandler handler;
            String cmd = line;
            String cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
                break;
            }
            if ((handler = cmdRegistry.getCommandHandler(cmd.toLowerCase())) != null) {
                cmdCtx.setArgs(cmd, cmdArgs, handler);
                if (cmdCtx.isBatchMode() && handler.isBatchMode()) {
                    if (!(handler instanceof OperationCommand)) {
                        cmdCtx.printLine("The command is not allowed in a batch.");
                    } else {
                        try {
                            ModelNode request = ((OperationCommand)handler).buildRequest(cmdCtx);
                            DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(line, request);
                            Batch batch = cmdCtx.getBatchManager().getActiveBatch();
                            batch.add(batchedCmd);
                            cmdCtx.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
                        }
                        catch (CommandFormatException e) {
                            cmdCtx.printLine("Failed to add to batch: " + e.getLocalizedMessage());
                        }
                    }
                } else {
                    try {
                        handler.handle(cmdCtx);
                    }
                    catch (CommandFormatException e) {
                        cmdCtx.printLine(e.getLocalizedMessage());
                    }
                }
                cmdCtx.setArgs(null, null, null);
            } else {
                cmdCtx.printLine("Unexpected command '" + line + "'. Type 'help' for the list of supported commands.");
            }
        }
    }

    protected static ConsoleReader initConsoleReader() {
        String osName = SecurityActions.getSystemProperty("os.name").toLowerCase();
        String bindingsName = osName.indexOf("windows") >= 0 ? "keybindings/jline-windows-bindings.properties" : (osName.startsWith("mac") ? "keybindings/jline-mac-bindings.properties" : "keybindings/jline-default-bindings.properties");
        ClassLoader cl = SecurityActions.getClassLoader(CommandLineMain.class);
        InputStream bindingsIs = cl.getResourceAsStream(bindingsName);
        if (bindingsIs == null) {
            System.err.println("Failed to locate key bindings for OS '" + osName + "': " + bindingsName);
            try {
                return new ConsoleReader();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize console reader", e);
            }
        }
        try {
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            String encoding = SecurityActions.getSystemProperty("jline.WindowsTerminal.output.encoding");
            if (encoding == null) {
                encoding = SecurityActions.getSystemProperty("file.encoding");
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
            ConsoleReader consoleReader = new ConsoleReader((InputStream)in, (Writer)out, bindingsIs);
            return consoleReader;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize console reader", e);
        }
        finally {
            StreamUtils.safeClose((Closeable)bindingsIs);
        }
    }

    private static boolean isOperation(String line) {
        char firstChar = line.charAt(0);
        return firstChar == '.' || firstChar == ':' || firstChar == '/' || line.startsWith("..") || line.startsWith(".type");
    }

    static {
        cmdRegistry.registerHandler((CommandHandler)new HelpHandler(), "help", "h");
        cmdRegistry.registerHandler((CommandHandler)new QuitHandler(), "quit", "q", "exit");
        cmdRegistry.registerHandler((CommandHandler)new ConnectHandler(), "connect");
        cmdRegistry.registerHandler((CommandHandler)new PrefixHandler(), "cd", "cn");
        cmdRegistry.registerHandler((CommandHandler)new LsHandler(), "ls");
        cmdRegistry.registerHandler((CommandHandler)new HistoryHandler(), "history");
        cmdRegistry.registerHandler((CommandHandler)new DeployHandler(), "deploy");
        cmdRegistry.registerHandler((CommandHandler)new UndeployHandler(), "undeploy");
        cmdRegistry.registerHandler((CommandHandler)new PrintWorkingNodeHandler(), "pwd", "pwn");
        cmdRegistry.registerHandler((CommandHandler)new JmsQueueAddHandler(), "add-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new JmsQueueRemoveHandler(), "remove-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new JmsTopicAddHandler(), "add-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new JmsTopicRemoveHandler(), "remove-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new JmsCFAddHandler(), "add-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new JmsCFRemoveHandler(), "remove-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsResourceHandler(), false, "create-jms-resource");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsResourceHandler(), false, "delete-jms-resource");
        cmdRegistry.registerHandler((CommandHandler)new BatchHandler(), "batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchDiscardHandler(), "discard-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchListHandler(), "list-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchHoldbackHandler(), "holdback-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRunHandler(), "run-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchClearHandler(), "clear-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRemoveLineHandler(), "remove-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchMoveLineHandler(), "move-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchEditLineHandler(), "edit-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new VersionHandler(), "version");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceAddHandler(), "add-data-source");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceModifyHandler(), "modify-data-source");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceRemoveHandler(), "remove-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceAddHandler(), "add-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceRemoveHandler(), "remove-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceModifyHandler(), "modify-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new CommandCommandHandler(cmdRegistry), "command");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=datasources/data-source", "jndi-name"), "data-source");
    }

    static class CommandContextImpl
    implements CommandContext {
        private final ConsoleReader console;
        private final CommandHistory history;
        private boolean terminate;
        private String cmd;
        private DefaultParsedArguments parsedArgs = new DefaultParsedArguments();
        private boolean domainMode;
        private ModelControllerClient client;
        private String defaultControllerHost = "localhost";
        private int defaultControllerPort = 9999;
        private String controllerHost;
        private int controllerPort = -1;
        private Map<String, Object> map = new HashMap<String, Object>();
        private final OperationRequestParser parser = new DefaultOperationRequestParser();
        private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
        private final PrefixFormatter prefixFormatter = new DefaultPrefixFormatter();
        private final OperationCandidatesProvider operationCandidatesProvider;
        private final OperationRequestHandler operationHandler;
        private BatchManager batchManager = new DefaultBatchManager();
        private final CommandCompleter cmdCompleter;
        String promptConnectPart;

        private CommandContextImpl() {
            this.console = null;
            this.history = null;
            this.operationCandidatesProvider = null;
            this.cmdCompleter = null;
            this.operationHandler = new OperationRequestHandler();
        }

        private CommandContextImpl(ConsoleReader console) {
            this.console = console;
            console.setUseHistory(true);
            String userHome = SecurityActions.getSystemProperty("user.home");
            File historyFile = new File(userHome, ".jboss-cli-history");
            try {
                console.getHistory().setHistoryFile(historyFile);
            }
            catch (IOException e) {
                System.err.println("Failed to setup the history file " + historyFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            this.history = new HistoryImpl();
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider(this);
            this.operationHandler = new OperationRequestHandler();
            this.cmdCompleter = new CommandCompleter(cmdRegistry, this);
        }

        @Override
        public String getArgumentsString() {
            return this.parsedArgs.getArgumentsString();
        }

        @Override
        public void terminateSession() {
            this.terminate = true;
        }

        @Override
        public void printLine(String message) {
            if (this.console != null) {
                try {
                    this.console.printString(message);
                    this.console.printNewline();
                }
                catch (IOException e) {
                    System.err.println("Failed to print '" + message + "' to the console: " + e.getLocalizedMessage());
                }
            } else {
                System.out.println(message);
            }
        }

        @Override
        public void printColumns(Collection<String> col) {
            if (this.console != null) {
                try {
                    this.console.printColumns(col);
                }
                catch (IOException e) {
                    System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
                }
            } else {
                for (String item : col) {
                    System.out.println(item);
                }
            }
        }

        @Override
        public void set(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public OperationRequestParser getOperationRequestParser() {
            return this.parser;
        }

        @Override
        public OperationRequestAddress getPrefix() {
            return this.prefix;
        }

        @Override
        public PrefixFormatter getPrefixFormatter() {
            return this.prefixFormatter;
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.operationCandidatesProvider;
        }

        private void connectController(String host, int port, boolean loggingEnabled) {
            if (host == null) {
                host = this.defaultControllerHost;
            }
            if (port < 0) {
                port = this.defaultControllerPort;
            }
            try {
                AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler();
                ModelControllerClient newClient = ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)cbh);
                if (this.client != null) {
                    this.disconnectController();
                }
                this.client = newClient;
                this.controllerHost = host;
                this.controllerPort = port;
                List<String> nodeTypes = Util.getNodeTypes(newClient, new DefaultOperationRequestAddress());
                if (!nodeTypes.isEmpty()) {
                    this.domainMode = nodeTypes.contains("server-group");
                    this.printLine("Connected to " + (this.domainMode ? "domain controller at " : "standalone controller at ") + host + ":" + port);
                } else {
                    this.printLine("The controller is not available at " + host + ":" + port);
                }
            }
            catch (UnknownHostException e) {
                this.printLine("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        }

        @Override
        public void connectController(String host, int port) {
            this.connectController(host, port, true);
        }

        private void disconnectController(boolean loggingEnabled) {
            if (this.client != null) {
                StreamUtils.safeClose((Closeable)this.client);
                if (loggingEnabled) {
                    this.printLine("Closed connection to " + this.controllerHost + ':' + this.controllerPort);
                }
                this.client = null;
                this.controllerHost = null;
                this.controllerPort = -1;
                this.domainMode = false;
            }
            this.promptConnectPart = null;
        }

        @Override
        public void disconnectController() {
            this.disconnectController(true);
        }

        @Override
        public String getControllerHost() {
            return this.controllerHost;
        }

        @Override
        public int getControllerPort() {
            return this.controllerPort;
        }

        String getPrompt() {
            StringBuilder buffer = new StringBuilder();
            if (this.promptConnectPart == null) {
                buffer.append('[');
                if (this.controllerHost != null) {
                    if (this.domainMode) {
                        buffer.append("domain@");
                    } else {
                        buffer.append("standalone@");
                    }
                    buffer.append(this.controllerHost).append(':').append(this.controllerPort).append(' ');
                    this.promptConnectPart = buffer.toString();
                } else {
                    buffer.append("disconnected ");
                }
            } else {
                buffer.append(this.promptConnectPart);
            }
            if (this.prefix.isEmpty()) {
                buffer.append('/');
            } else {
                buffer.append(this.prefix.getNodeType());
                String nodeName = this.prefix.getNodeName();
                if (nodeName != null) {
                    buffer.append('=').append(nodeName);
                }
            }
            if (this.isBatchMode()) {
                buffer.append(" #");
            }
            buffer.append("] ");
            return buffer.toString();
        }

        @Override
        public CommandHistory getHistory() {
            return this.history;
        }

        @Override
        public String getDefaultControllerHost() {
            return this.defaultControllerHost;
        }

        @Override
        public int getDefaultControllerPort() {
            return this.defaultControllerPort;
        }

        private void setArgs(String cmd, String args, CommandHandler handler) {
            this.cmd = cmd;
            this.parsedArgs.reset(args, handler);
        }

        @Override
        public boolean isBatchMode() {
            return this.batchManager.isBatchActive();
        }

        @Override
        public String getCommand() {
            return this.cmd;
        }

        @Override
        public BatchManager getBatchManager() {
            return this.batchManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
            CommandHandler handler;
            if (line.isEmpty()) {
                throw new IllegalArgumentException("Null command line.");
            }
            DefaultParsedArguments originalParsedArguments = this.parsedArgs;
            if (CommandLineMain.isOperation(line)) {
                try {
                    this.parsedArgs = new DefaultParsedArguments();
                    this.setArgs(null, line, null);
                    DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(this.getPrefix());
                    this.parser.parse(line, builder);
                    ModelNode request = builder.buildRequest();
                    StringBuilder op = new StringBuilder();
                    op.append(this.prefixFormatter.format(builder.getAddress()));
                    op.append(line.substring(line.indexOf(58)));
                    DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(op.toString(), request);
                    return defaultBatchedCommand;
                }
                finally {
                    this.parsedArgs = originalParsedArguments;
                }
            }
            String cmd = line;
            String cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
                break;
            }
            if ((handler = cmdRegistry.getCommandHandler(cmd.toLowerCase())) == null) {
                throw new OperationFormatException("No command handler for '" + cmd + "'.");
            }
            if (!(handler instanceof OperationCommand)) {
                throw new OperationFormatException("The command is not allowed in a batch.");
            }
            try {
                this.parsedArgs = new DefaultParsedArguments();
                this.setArgs(cmd, cmdArgs, handler);
                ModelNode request = ((OperationCommand)handler).buildRequest(this);
                DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(line, request);
                return defaultBatchedCommand;
            }
            finally {
                this.parsedArgs = originalParsedArguments;
            }
        }

        @Override
        public CommandLineCompleter getDefaultCommandCompleter() {
            return this.cmdCompleter;
        }

        @Override
        public ParsedArguments getParsedArguments() {
            return this.parsedArgs;
        }

        @Override
        public boolean isDomainMode() {
            return this.domainMode;
        }

        private class HistoryImpl
        implements CommandHistory {
            private HistoryImpl() {
            }

            @Override
            public List<String> asList() {
                return CommandContextImpl.this.console.getHistory().getHistoryList();
            }

            @Override
            public boolean isUseHistory() {
                return CommandContextImpl.this.console.getUseHistory();
            }

            @Override
            public void setUseHistory(boolean useHistory) {
                CommandContextImpl.this.console.setUseHistory(useHistory);
            }

            @Override
            public void clear() {
                CommandContextImpl.this.console.getHistory().clear();
            }
        }

        private class AuthenticationCallbackHandler
        implements CallbackHandler {
            private boolean realmShown = false;
            private String userName = null;
            private char[] password = null;

            private AuthenticationCallbackHandler() {
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                    ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                    return;
                }
                for (Callback current : callbacks) {
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        String defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        if (this.realmShown) continue;
                        this.realmShown = true;
                        CommandContextImpl.this.printLine("Authenticating against security realm: " + defaultText);
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) {
                        throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                    }
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        if (this.userName == null) {
                            this.userName = CommandContextImpl.this.console.readLine("Username:");
                        }
                        ncb.setName(this.userName);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        String temp;
                        PasswordCallback pcb = (PasswordCallback)current;
                        if (this.password == null && (temp = CommandContextImpl.this.console.readLine("Password:", Character.valueOf('*'))) != null) {
                            this.password = temp.toCharArray();
                        }
                        pcb.setPassword(this.password);
                        continue;
                    }
                    CommandContextImpl.this.printLine("Unexpected Callback " + current.getClass().getName());
                    throw new UnsupportedCallbackException(current);
                }
            }
        }
    }
}

