/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static ClassLoader getClassLoader(Class<?> cls) {
        return TCLAction.UTIL.getClassLoader(cls);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public ClassLoader getClassLoader(Class<?> cls) {
                return cls.getClassLoader();
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public ClassLoader getClassLoader(final Class<?> cls) {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return cls.getClassLoader();
                    }
                });
            }
        };

        public ClassLoader getClassLoader(Class<?> var1);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            public static ClassLoader getClassLoader(Class<?> cls) {
                return UTIL.getTCLAction().getClassLoader(cls);
            }
        }
    }
}

