/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.concurrent.CancellationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class OperationRequestHandler
implements CommandHandler {
    @Override
    public void handle(CommandContext ctx) {
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            ctx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            return;
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(ctx.getPrefix());
        try {
            ctx.getOperationRequestParser().parse(ctx.getCommandArguments(), builder);
            ModelNode request = builder.buildRequest();
            ModelNode result = client.execute(request);
            ctx.printLine(result.toString());
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
        }
        catch (NoSuchElementException e) {
            ctx.printLine("ModelNode request is incomplete: " + e.getMessage());
        }
        catch (CancellationException e) {
            ctx.printLine("The result couldn't be retrieved (perhaps the task was cancelled: " + e.getLocalizedMessage());
        }
        catch (IOException e) {
            ctx.printLine("Communication error: " + e.getLocalizedMessage());
        }
    }
}

