/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.PrefixFormatter;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;

public class CommandLineMain {
    private static final Map<String, CommandHandler> handlers = new HashMap<String, CommandHandler>();
    private static final CommandHandler operationHandler;

    private static void registerHandler(CommandHandler handler, String ... names) {
        for (String name : names) {
            CommandHandler previous = handlers.put(name, handler);
            if (previous == null) continue;
            throw new IllegalStateException("Duplicate command name '" + name + "'. Handlers: " + previous + ", " + handler);
        }
    }

    public static void main(String[] args) throws Exception {
        ConsoleReader console = new ConsoleReader();
        final CommandContextImpl cmdCtx = new CommandContextImpl(console);
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        OperationRequestCompleter opCompleter = new OperationRequestCompleter(cmdCtx);
        console.addCompletor((Completor)new CommandCompleter(handlers.keySet(), opCompleter));
        console.addCompletor((Completor)opCompleter);
        boolean connect = false;
        for (String arg : args) {
            if (arg.startsWith("controller=")) {
                String value = arg.substring(11);
                String portStr = null;
                int colonIndex = value.indexOf(58);
                if (colonIndex < 0) {
                    cmdCtx.defaultControllerHost = value;
                } else if (colonIndex == 0) {
                    portStr = value.substring(1);
                } else {
                    cmdCtx.defaultControllerHost = value.substring(0, colonIndex);
                    portStr = value.substring(colonIndex + 1);
                }
                if (portStr == null) continue;
                int port = -1;
                try {
                    port = Integer.parseInt(portStr);
                    if (port < 0) {
                        cmdCtx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                        continue;
                    }
                    cmdCtx.defaultControllerPort = port;
                }
                catch (NumberFormatException e) {
                    cmdCtx.printLine("The port must be a valid non-negative integer: '" + arg + "'");
                }
                continue;
            }
            if (!"--connect".equals(arg)) continue;
            connect = true;
        }
        if (connect) {
            cmdCtx.connectController(null, -1);
        } else {
            cmdCtx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        }
        while (!cmdCtx.terminate) {
            CommandHandler handler;
            String line = console.readLine(cmdCtx.getPrompt()).trim();
            if (line.isEmpty()) continue;
            if (CommandLineMain.isOperation(line)) {
                cmdCtx.cmdArgs = line;
                operationHandler.handle(cmdCtx);
                continue;
            }
            String cmd = line;
            cmdCtx.cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdCtx.cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
                break;
            }
            if ((handler = handlers.get(cmd.toLowerCase())) != null) {
                handler.handle(cmdCtx);
                continue;
            }
            cmdCtx.printLine("Unexpected command '" + line + "'. Type 'help' for the list of supported commands.");
        }
        StreamUtils.safeClose((Closeable)cmdCtx.client);
    }

    private static boolean isOperation(String line) {
        char firstChar = line.charAt(0);
        return firstChar == '.' || firstChar == ':' || firstChar == '/' || line.startsWith("..") || line.startsWith(".type");
    }

    static {
        CommandLineMain.registerHandler(new HelpHandler(), "help", "h");
        CommandLineMain.registerHandler(new QuitHandler(), "quit", "q");
        CommandLineMain.registerHandler(new ConnectHandler(), "connect");
        CommandLineMain.registerHandler(new PrefixHandler(), "cd", "cn");
        CommandLineMain.registerHandler(new LsHandler(), "ls");
        CommandLineMain.registerHandler(new HistoryHandler(), "history");
        CommandLineMain.registerHandler(new DeployHandler(), "deploy");
        CommandLineMain.registerHandler(new UndeployHandler(), "undeploy");
        CommandLineMain.registerHandler(new PrintWorkingNodeHandler(), "pwn", "pwd");
        operationHandler = new OperationRequestHandler();
    }

    private static class CommandContextImpl
    implements CommandContext {
        private final ConsoleReader console;
        private final CommandHistory history;
        private boolean terminate;
        private String cmdArgs;
        private ModelControllerClient client;
        private String defaultControllerHost = "localhost";
        private int defaultControllerPort = 9999;
        private String controllerHost;
        private int controllerPort = -1;
        private Map<String, Object> map = new HashMap<String, Object>();
        private final OperationRequestParser parser = new DefaultOperationRequestParser();
        private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
        private final PrefixFormatter prefixFormatter = new DefaultPrefixFormatter();
        private final OperationCandidatesProvider operationCandidatesProvider;

        private CommandContextImpl(ConsoleReader console) {
            this.console = console;
            console.setUseHistory(true);
            String userHome = SecurityActions.getSystemProperty("user.home");
            File historyFile = new File(userHome, ".jboss-cli-history");
            try {
                console.getHistory().setHistoryFile(historyFile);
            }
            catch (IOException e) {
                System.err.println("Failed to setup the history file " + historyFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            this.history = new HistoryImpl();
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider(this);
        }

        @Override
        public String getCommandArguments() {
            return this.cmdArgs;
        }

        @Override
        public void terminateSession() {
            this.terminate = true;
        }

        @Override
        public void printLine(String message) {
            try {
                this.console.printString(message);
                this.console.printNewline();
            }
            catch (IOException e) {
                System.err.println("Failed to print '" + message + "' to the console: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void printColumns(Collection<String> col) {
            try {
                this.console.printColumns(col);
            }
            catch (IOException e) {
                System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void set(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public OperationRequestParser getOperationRequestParser() {
            return this.parser;
        }

        @Override
        public OperationRequestAddress getPrefix() {
            return this.prefix;
        }

        @Override
        public PrefixFormatter getPrefixFormatter() {
            return this.prefixFormatter;
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.operationCandidatesProvider;
        }

        @Override
        public void connectController(String host, int port) {
            if (host == null) {
                host = this.defaultControllerHost;
            }
            if (port < 0) {
                port = this.defaultControllerPort;
            }
            try {
                ModelControllerClient newClient = ModelControllerClient.Factory.create((String)host, (int)port);
                if (this.client != null) {
                    this.disconnectController();
                }
                this.printLine("Connected to " + host + ":" + port);
                this.client = newClient;
                this.controllerHost = host;
                this.controllerPort = port;
            }
            catch (UnknownHostException e) {
                this.printLine("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        }

        @Override
        public void disconnectController() {
            if (this.client != null) {
                StreamUtils.safeClose((Closeable)this.client);
                this.printLine("Closed connection to " + this.controllerHost + ':' + this.controllerPort);
                this.client = null;
                this.controllerHost = null;
                this.controllerPort = -1;
            }
        }

        @Override
        public String getControllerHost() {
            return this.controllerHost;
        }

        @Override
        public int getControllerPort() {
            return this.controllerPort;
        }

        String getPrompt() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('[');
            if (this.controllerHost != null) {
                buffer.append(this.controllerHost).append(':').append(this.controllerPort).append(' ');
            } else {
                buffer.append("disconnected ");
            }
            if (this.prefix.isEmpty()) {
                buffer.append('/');
            } else {
                String nodeName = this.prefix.getNodeName();
                if (nodeName == null) {
                    buffer.append(this.prefix.getNodeType());
                } else {
                    buffer.append(nodeName);
                }
            }
            buffer.append("] ");
            return buffer.toString();
        }

        @Override
        public CommandHistory getHistory() {
            return this.history;
        }

        @Override
        public String getDefaultControllerHost() {
            return this.defaultControllerHost;
        }

        @Override
        public int getDefaultControllerPort() {
            return this.defaultControllerPort;
        }

        private class HistoryImpl
        implements CommandHistory {
            private HistoryImpl() {
            }

            @Override
            public List<String> asList() {
                return CommandContextImpl.this.console.getHistory().getHistoryList();
            }

            @Override
            public boolean isUseHistory() {
                return CommandContextImpl.this.console.getUseHistory();
            }

            @Override
            public void setUseHistory(boolean useHistory) {
                CommandContextImpl.this.console.setUseHistory(useHistory);
            }

            @Override
            public void clear() {
                CommandContextImpl.this.console.getHistory().clear();
            }
        }
    }
}

