/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.transactions;

import java.lang.reflect.Type;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.CoreConfiguration;
import org.javers.core.Javers;
import org.javers.core.changelog.ChangeProcessor;
import org.javers.core.commit.Commit;
import org.javers.core.diff.Change;
import org.javers.core.diff.Diff;
import org.javers.core.diff.changetype.PropertyChange;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversType;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.JqlQuery;
import org.javers.shadow.Shadow;
import org.springframework.transaction.annotation.Transactional;

public abstract class JaversTransactionalDecorator
implements Javers {
    private final Javers delegate;

    protected JaversTransactionalDecorator(Javers delegate) {
        Validate.argumentsAreNotNull((Object[])new Object[]{delegate});
        this.delegate = delegate;
    }

    public CompletableFuture<Commit> commitAsync(String author, Object currentVersion, Map<String, String> commitProperties, Executor executor) {
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[]{"javers.commitAsync() is not available for SQL"});
    }

    public CompletableFuture<Commit> commitAsync(String author, Object currentVersion, Executor executor) {
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[]{"javers.commitAsync() is not available for SQL"});
    }

    @Transactional
    public Commit commit(String author, Object currentVersion) {
        return this.delegate.commit(author, currentVersion);
    }

    @Transactional
    public Commit commit(String author, Object currentVersion, Map<String, String> commitProperties) {
        return this.delegate.commit(author, currentVersion, commitProperties);
    }

    @Transactional
    public Commit commitShallowDelete(String author, Object deleted) {
        return this.delegate.commitShallowDelete(author, deleted);
    }

    @Transactional
    public Commit commitShallowDelete(String author, Object deleted, Map<String, String> properties) {
        return this.delegate.commitShallowDelete(author, deleted, properties);
    }

    @Transactional
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId) {
        return this.delegate.commitShallowDeleteById(author, globalId);
    }

    @Transactional
    public Commit commitShallowDeleteById(String author, GlobalIdDTO globalId, Map<String, String> properties) {
        return this.delegate.commitShallowDeleteById(author, globalId, properties);
    }

    public Diff compare(Object oldVersion, Object currentVersion) {
        return this.delegate.compare(oldVersion, currentVersion);
    }

    public <T> Diff compareCollections(Collection<T> oldVersion, Collection<T> currentVersion, Class<T> itemClass) {
        return this.delegate.compareCollections(oldVersion, currentVersion, itemClass);
    }

    public Diff initial(Object newDomainObject) {
        return this.delegate.initial(newDomainObject);
    }

    @Transactional
    public Optional<CdoSnapshot> getLatestSnapshot(Object localId, Class entityClass) {
        return this.delegate.getLatestSnapshot(localId, entityClass);
    }

    @Transactional
    public Optional<CdoSnapshot> getHistoricalSnapshot(Object localId, Class entity, LocalDateTime effectiveDate) {
        return this.delegate.getHistoricalSnapshot(localId, entity, effectiveDate);
    }

    @Transactional
    public <T> List<Shadow<T>> findShadows(JqlQuery query) {
        return this.delegate.findShadows(query);
    }

    @Transactional
    public <T> Stream<Shadow<T>> findShadowsAndStream(JqlQuery query) {
        return this.delegate.findShadowsAndStream(query);
    }

    @Transactional
    public List<CdoSnapshot> findSnapshots(JqlQuery query) {
        return this.delegate.findSnapshots(query);
    }

    @Transactional
    public Changes findChanges(JqlQuery query) {
        return this.delegate.findChanges(query);
    }

    public JsonConverter getJsonConverter() {
        return this.delegate.getJsonConverter();
    }

    public <T> T processChangeList(List<Change> changes, ChangeProcessor<T> changeProcessor) {
        return (T)this.delegate.processChangeList(changes, changeProcessor);
    }

    public <T extends JaversType> T getTypeMapping(Type clientsType) {
        return (T)this.delegate.getTypeMapping(clientsType);
    }

    public CoreConfiguration getCoreConfiguration() {
        return this.delegate.getCoreConfiguration();
    }

    public Property getProperty(PropertyChange propertyChange) {
        return this.delegate.getProperty(propertyChange);
    }
}

