/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect;

import org.aspectj.lang.JoinPoint;
import org.javers.common.collections.Maps;
import org.javers.core.Javers;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;

public class JaversCommitAdvice {
    private final Javers javers;
    private final AuthorProvider authorProvider;
    private final CommitPropertiesProvider commitPropertiesProvider;

    public JaversCommitAdvice(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
        this.commitPropertiesProvider = commitPropertiesProvider;
    }

    public void commitSaveMethodArguments(JoinPoint pjp) {
        for (Object arg : AspectUtil.collectArguments(pjp)) {
            this.commitObject(arg);
        }
    }

    public void commitDeleteMethodArguments(JoinPoint pjp) {
        for (Object arg : AspectUtil.collectArguments(pjp)) {
            this.commitShallowDelete(arg);
        }
    }

    public void commitObject(Object domainObject) {
        String author = this.authorProvider.provide();
        this.javers.commit(author, domainObject, Maps.merge(this.commitPropertiesProvider.provideForCommittedObject(domainObject), this.commitPropertiesProvider.provide()));
    }

    public void commitShallowDelete(Object domainObject) {
        String author = this.authorProvider.provide();
        this.javers.commitShallowDelete(author, domainObject, Maps.merge(this.commitPropertiesProvider.provideForDeletedObject(domainObject), this.commitPropertiesProvider.provide()));
    }

    public void commitShallowDeleteById(Object domainObjectId, Class<?> domainType) {
        String author = this.authorProvider.provide();
        this.javers.commitShallowDeleteById(author, (GlobalIdDTO)InstanceIdDTO.instanceId((Object)domainObjectId, domainType), Maps.merge(this.commitPropertiesProvider.provideForDeleteById(domainType, domainObjectId), this.commitPropertiesProvider.provide()));
    }
}

