/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.aopalliance.aop.Advice;
import org.javers.common.collections.Sets;
import org.javers.core.Javers;
import org.javers.spring.AuthorProvider;
import org.javers.spring.DefaultAuthorProvider;
import org.javers.spring.JaversAuditable;
import org.javers.spring.aspect.JaversCommitAdvice;
import org.javers.spring.aspect.MethodEqualsBasedMatcher;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class JaversPostProcessor
implements BeanPostProcessor {
    private final Javers javers;
    private final AuthorProvider authorProvider;

    public JaversPostProcessor(Javers javers) {
        this(javers, new DefaultAuthorProvider());
    }

    public JaversPostProcessor(Javers javers, AuthorProvider authorProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) {
        return this.proxy(bean);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) {
        return bean;
    }

    private Object proxy(Object bean) {
        Class<?> beanClazz = bean.getClass();
        HashSet<Method> advicedMethods = new HashSet<Method>();
        if (this.isAuditableClass(beanClazz)) {
            advicedMethods.addAll(Sets.asSet((Object[])beanClazz.getDeclaredMethods()));
        } else {
            for (Method method : beanClazz.getDeclaredMethods()) {
                if (!this.isAuditableMethod(method)) continue;
                advicedMethods.add(method);
            }
        }
        ProxyFactory proxyFactory = this.proxyFactoryWithAdvisors(bean, advicedMethods);
        return proxyFactory.getAdvisors().length > 0 ? proxyFactory.getProxy() : bean;
    }

    private ProxyFactory proxyFactoryWithAdvisors(Object bean, Set<Method> methods) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(bean);
        this.addAdvisors(proxyFactory, methods);
        return proxyFactory;
    }

    private void addAdvisors(ProxyFactory proxyFactory, Set<Method> methods) {
        for (Method method : methods) {
            proxyFactory.addAdvisor((Advisor)new DefaultPointcutAdvisor((Pointcut)new MethodEqualsBasedMatcher(method), (Advice)new JaversCommitAdvice(this.javers, this.authorProvider.provide())));
        }
    }

    private boolean isAuditableClass(Class bean) {
        return bean.isAnnotationPresent(JaversAuditable.class);
    }

    private boolean isAuditableMethod(Method method) {
        return method.isAnnotationPresent(JaversAuditable.class);
    }
}

