/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.mongodb;

import com.mongodb.client.ClientSession;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.core.CoreConfiguration;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.ConfigurationAware;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.mongo.MongoRepository;
import org.springframework.data.mongodb.ClientSessionExtractor;
import org.springframework.data.mongodb.MongoTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.TransactionTemplate;

class TransactionalMongoRepository
implements JaversRepository,
ConfigurationAware {
    private final MongoRepository delegate;
    private final TransactionTemplate transactionTemplate;

    TransactionalMongoRepository(MongoRepository delegate, MongoTransactionManager txManager) {
        this.delegate = delegate;
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)txManager);
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        return this.delegate.getStateHistory(globalId, queryParams);
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        return this.delegate.getValueObjectStateHistory(ownerEntity, path, queryParams);
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        return this.delegate.getStateHistory(givenClasses, queryParams);
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.delegate.getLatest(globalId);
    }

    public List<CdoSnapshot> getLatest(Collection<GlobalId> globalIds) {
        return this.delegate.getLatest(globalIds);
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.delegate.getSnapshots(queryParams);
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return this.delegate.getSnapshots(snapshotIdentifiers);
    }

    public void persist(Commit commit) {
        this.transactionTemplate.execute(status -> {
            ClientSession session = ClientSessionExtractor.getFrom((DefaultTransactionStatus)status);
            this.delegate.persist(commit, session);
            return null;
        });
    }

    public CommitId getHeadId() {
        return this.delegate.getHeadId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.delegate.setJsonConverter(jsonConverter);
    }

    public void ensureSchema() {
        this.delegate.ensureSchema();
    }

    public void setConfiguration(CoreConfiguration coreConfiguration) {
        this.delegate.setConfiguration(coreConfiguration);
    }
}

