/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.sql;

import org.javers.core.Javers;
import org.javers.core.MappingStyle;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.graph.ObjectAccessHook;
import org.javers.hibernate.integration.HibernateUnproxyObjectAccessHook;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.SqlRepositoryBuilder;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableRepositoryAspect;
import org.javers.spring.boot.sql.DialectMapper;
import org.javers.spring.boot.sql.JaversProperties;
import org.javers.spring.jpa.JpaHibernateConnectionProvider;
import org.javers.spring.jpa.TransactionalJaversBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.orm.jpa.JpaProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversProperties.class, JpaProperties.class})
public class JaversSqlAutoConfiguration {
    private final DialectMapper dialectMapper = new DialectMapper();
    @Autowired
    private JaversProperties javersProperties;
    @Autowired
    JpaProperties jpaProperties;

    @Bean
    public Javers javers(ConnectionProvider connectionProvider) {
        JaversSqlRepository sqlRepository = SqlRepositoryBuilder.sqlRepository().withConnectionProvider(connectionProvider).withDialect(this.dialectMapper.apply(this.jpaProperties.getDatabase())).build();
        return TransactionalJaversBuilder.javers().registerJaversRepository((JaversRepository)sqlRepository).withObjectAccessHook((ObjectAccessHook)new HibernateUnproxyObjectAccessHook()).withListCompareAlgorithm(ListCompareAlgorithm.valueOf((String)this.javersProperties.getAlgorithm().toUpperCase())).withMappingStyle(MappingStyle.valueOf((String)this.javersProperties.getMappingStyle().toUpperCase())).withNewObjectsSnapshot(this.javersProperties.isNewObjectSnapshot()).withPrettyPrint(this.javersProperties.isPrettyPrint()).withTypeSafeValues(this.javersProperties.isTypeSafeValues()).build();
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorProvider authorProvider() {
        return new AuthorProvider(){

            public String provide() {
                return "unknown";
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public ConnectionProvider jpaConnectionProvider() {
        return new JpaHibernateConnectionProvider();
    }

    @Bean
    public JaversAuditableRepositoryAspect javersAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider) {
        return new JaversAuditableRepositoryAspect(javers, authorProvider);
    }
}

