/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.Optional;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.JaversCoreProperties;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.MongoRepository;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.EmptyPropertiesProvider;
import org.javers.spring.auditable.MockAuthorProvider;
import org.javers.spring.auditable.SpringSecurityAuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableAspect;
import org.javers.spring.auditable.aspect.springdata.JaversSpringDataAuditableRepositoryAspect;
import org.javers.spring.boot.mongo.JaversDedicatedMongoFactory;
import org.javers.spring.boot.mongo.JaversMongoProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mongo.MongoProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

@Configuration
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={JaversMongoProperties.class})
public class JaversMongoAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JaversMongoAutoConfiguration.class);
    @Autowired
    private JaversMongoProperties javersMongoProperties;
    @Autowired
    private MongoClient mongoClient;
    @Autowired
    private MongoProperties mongoProperties;
    @Autowired
    @Qualifier(value="javersMongoClientSettings")
    private Optional<MongoClientSettings> mongoClientSettings;

    @Bean(name={"JaversFromStarter"})
    @ConditionalOnMissingBean
    public Javers javers() {
        logger.info("Starting javers-spring-boot-starter-mongo ...");
        MongoDatabase mongoDatabase = this.initJaversMongoDatabase();
        MongoRepository javersRepository = this.createMongoRepository(mongoDatabase);
        return JaversBuilder.javers().registerJaversRepository((JaversRepository)javersRepository).withProperties((JaversCoreProperties)this.javersMongoProperties).withObjectAccessHook(this.javersMongoProperties.createObjectAccessHookInstance()).build();
    }

    private MongoDatabase initJaversMongoDatabase() {
        if (!this.javersMongoProperties.isDedicatedMongodbConfigurationEnabled()) {
            MongoDatabase mongoDatabase = this.mongoClient.getDatabase(this.mongoProperties.getMongoClientDatabase());
            logger.info("connecting Javers to Mongo database '{}' configured in spring.data.mongodb properties", (Object)mongoDatabase.getName());
            return mongoDatabase;
        }
        MongoDatabase mongoDatabase = JaversDedicatedMongoFactory.createMongoDatabase(this.javersMongoProperties, this.mongoClientSettings);
        logger.info("connecting Javers to Mongo database '{}' configured in javers.mongodb properties", (Object)mongoDatabase.getName());
        return mongoDatabase;
    }

    private MongoRepository createMongoRepository(MongoDatabase mongoDatabase) {
        if (this.javersMongoProperties.isDocumentDbCompatibilityEnabled()) {
            logger.info("enabling Amazon DocumentDB compatibility");
            return MongoRepository.mongoRepositoryWithDocumentDBCompatibility((MongoDatabase)mongoDatabase, (int)this.javersMongoProperties.getSnapshotsCacheSize());
        }
        return new MongoRepository(mongoDatabase, this.javersMongoProperties.getSnapshotsCacheSize());
    }

    @Bean(name={"SpringSecurityAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider springSecurityAuthorProvider() {
        return new SpringSecurityAuthorProvider();
    }

    @Bean(name={"MockAuthorProvider"})
    @ConditionalOnMissingBean
    @ConditionalOnMissingClass(value={"org.springframework.security.core.context.SecurityContextHolder"})
    public AuthorProvider unknownAuthorProvider() {
        return new MockAuthorProvider();
    }

    @Bean(name={"EmptyPropertiesProvider"})
    @ConditionalOnMissingBean
    public CommitPropertiesProvider commitPropertiesProvider() {
        return new EmptyPropertiesProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"javers.auditableAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversAuditableAspect javersAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversAuditableAspect(javers, authorProvider, commitPropertiesProvider);
    }

    @Bean
    @ConditionalOnProperty(name={"javers.springDataAuditableRepositoryAspectEnabled"}, havingValue="true", matchIfMissing=true)
    public JaversSpringDataAuditableRepositoryAspect javersSpringDataAuditableAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        return new JaversSpringDataAuditableRepositoryAspect(javers, authorProvider, commitPropertiesProvider);
    }
}

