/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.boot.mongo;

import com.mongodb.client.MongoDatabase;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.core.MappingStyle;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.MongoRepository;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.aspect.JaversAuditableRepositoryAspect;
import org.javers.spring.boot.mongo.JaversProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={JaversProperties.class})
public class JaversMongoAutoConfiguration {
    @Autowired
    private JaversProperties javersProperties;
    @Autowired
    private MongoDatabase mongoDatabase;

    @Bean
    public Javers javers() {
        MongoRepository javersRepository = new MongoRepository(this.mongoDatabase);
        return JaversBuilder.javers().withListCompareAlgorithm(ListCompareAlgorithm.valueOf((String)this.javersProperties.getAlgorithm().toUpperCase())).withMappingStyle(MappingStyle.valueOf((String)this.javersProperties.getMappingStyle().toUpperCase())).withNewObjectsSnapshot(this.javersProperties.isNewObjectSnapshot()).withPrettyPrint(this.javersProperties.isPrettyPrint()).withTypeSafeValues(this.javersProperties.isTypeSafeValues()).registerJaversRepository((JaversRepository)javersRepository).build();
    }

    @Bean
    public JaversAuditableRepositoryAspect javersAuditableRepositoryAspect() {
        return new JaversAuditableRepositoryAspect(this.javers(), this.authorProvider());
    }

    @Bean
    @ConditionalOnMissingBean
    public AuthorProvider authorProvider() {
        return new AuthorProvider(){

            public String provide() {
                return "unknown";
            }
        };
    }
}

