/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.regex.Pattern;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.repository.sql.session.Parameter;
import org.polyjdbc.core.type.ColumnTypeMapper;

abstract class Query {
    private static final Pattern ARGUMENT_PATTERN = Pattern.compile("\\$[A-Za-z0-9_-]*");
    private static ColumnTypeMapper columnTypeMapper = new ColumnTypeMapper();
    private final String name;
    private final List<Parameter> orderedParameters;
    private final String rawSQL;

    Query(String name, List<Parameter> params, String rawSQL) {
        this.name = name;
        this.rawSQL = rawSQL;
        this.orderedParameters = params;
    }

    String rawSQl() {
        return this.rawSQL;
    }

    String name() {
        return this.name;
    }

    void injectValuesTo(PreparedStatement preparedStatement) throws SQLException {
        int parameterNumber = 1;
        for (Parameter parameter : this.orderedParameters) {
            parameter.injectValuesTo(preparedStatement, parameterNumber);
            ++parameterNumber;
        }
    }

    private Parameter findParameter(String name, List<Parameter> params) {
        return params.stream().filter(it -> it.getName().equals(name)).findFirst().orElseThrow(() -> new JaversException(JaversExceptionCode.RUNTIME_EXCEPTION, new Object[]{"parameter '" + name + "' not found in raw SQL '" + this.rawSQL + "'"}));
    }
}

