/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.session;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.javers.repository.sql.session.KeyGeneratorDefinition;
import org.javers.repository.sql.session.Select;
import org.javers.repository.sql.session.Sequence;
import org.javers.repository.sql.session.Session;

interface KeyGenerator {
    public long generateKey(String var1, Session var2);

    public long getKeyFromLastInsert(Session var1);

    public void reset();

    public static class AutoincrementGenerator
    implements KeyGenerator {
        private final KeyGeneratorDefinition.AutoincrementDefinition autoincrementDefinition;

        AutoincrementGenerator(KeyGeneratorDefinition.AutoincrementDefinition autoincrementDefinition) {
            this.autoincrementDefinition = autoincrementDefinition;
        }

        @Override
        public long generateKey(String sequenceName, Session session) {
            throw new RuntimeException("Not implemented. Can't generate key on AutoIncremented");
        }

        @Override
        public long getKeyFromLastInsert(Session session) {
            return session.executeQueryForLong(new Select("last autoincrementDefinition id", this.autoincrementDefinition.lastInsertedAutoincrement()));
        }

        @Override
        public void reset() {
        }
    }

    public static class SequenceAllocation
    implements KeyGenerator {
        private final Object lock = new Object();
        private final KeyGeneratorDefinition.SequenceDefinition sequenceDefinition;
        private Map<String, Sequence> sequences = new ConcurrentHashMap<String, Sequence>();
        private ThreadLocal<Long> lastKey = new ThreadLocal();

        SequenceAllocation(KeyGeneratorDefinition.SequenceDefinition sequenceDefinition) {
            this.sequenceDefinition = sequenceDefinition;
        }

        @Override
        public long generateKey(String sequenceName, Session session) {
            long nextVal = this.findSequence(sequenceName).nextValue(session);
            this.lastKey.set(nextVal);
            return nextVal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Sequence findSequence(String sequenceName) {
            if (!this.sequences.containsKey(sequenceName)) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.sequences.containsKey(sequenceName)) {
                        Sequence sequence = new Sequence(sequenceName, this.sequenceDefinition);
                        this.sequences.put(sequenceName, sequence);
                    }
                }
            }
            return this.sequences.get(sequenceName);
        }

        @Override
        public long getKeyFromLastInsert(Session session) {
            return this.lastKey.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() {
            Object object = this.lock;
            synchronized (object) {
                this.sequences.clear();
            }
        }
    }
}

