/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.schema.TableNameProvider;
import org.javers.repository.sql.session.ObjectMapper;
import org.javers.repository.sql.session.Parameter;
import org.javers.repository.sql.session.SelectBuilder;
import org.javers.repository.sql.session.Session;

class SnapshotQuery {
    private final QueryParams queryParams;
    private final SelectBuilder selectBuilder;
    private final TableNameProvider tableNameProvider;
    private final CdoSnapshotMapper cdoSnapshotMapper = new CdoSnapshotMapper();

    public SnapshotQuery(TableNameProvider tableNames, QueryParams queryParams, Session session) {
        this.selectBuilder = (SelectBuilder)session.select("state, type, version, changed_properties, managed_type, commit_pk, author, commit_date, commit_date_instant, commit_id, g.local_id, g.fragment, g.owner_id_fk, o.local_id owner_local_id, o.fragment owner_fragment, o.type_name owner_type_name").from(tableNames.getSnapshotTableNameWithSchema() + " INNER JOIN " + tableNames.getCommitTableNameWithSchema() + " ON " + "commit_pk" + " = " + "commit_fk" + " INNER JOIN " + tableNames.getGlobalIdTableNameWithSchema() + " g ON g." + "global_id_pk" + " = " + "global_id_fk" + " LEFT OUTER JOIN " + tableNames.getGlobalIdTableNameWithSchema() + " o ON o." + "global_id_pk" + " = g." + "owner_id_fk").queryName("snapshots");
        this.queryParams = queryParams;
        this.tableNameProvider = tableNames;
        this.applyQueryParams();
    }

    private void applyQueryParams() {
        this.queryParams.changedProperty().ifPresent(changedProperty -> this.selectBuilder.and("changed_properties", "like", Parameter.stringParam("%\"" + (String)this.queryParams.changedProperty().get() + "\"%")));
        this.queryParams.from().ifPresent(from -> this.selectBuilder.and("commit_date", ">=", Parameter.localDateTimeParam(from)));
        this.queryParams.to().ifPresent(to -> this.selectBuilder.and("commit_date", "<=", Parameter.localDateTimeParam(to)));
        this.queryParams.toCommitId().ifPresent(commitId -> this.selectBuilder.and("commit_id", "<=", Parameter.bigDecimalParam(commitId.valueAsNumber())));
        if (this.queryParams.commitIds().size() > 0) {
            this.selectBuilder.and("commit_id IN (" + ToStringBuilder.join((Collection)this.queryParams.commitIds().stream().map(c -> c.valueAsNumber()).collect(Collectors.toList())) + ")", new Parameter[0]);
        }
        this.queryParams.version().ifPresent(ver -> this.selectBuilder.and("version", (Long)ver));
        this.queryParams.author().ifPresent(author -> this.selectBuilder.and("author", (String)author));
        if (this.queryParams.commitProperties().size() > 0) {
            for (Map.Entry commitProperty : this.queryParams.commitProperties().entrySet()) {
                this.addCommitPropertyFilter(this.selectBuilder, (String)commitProperty.getKey(), (String)commitProperty.getValue());
            }
        }
        this.queryParams.snapshotType().ifPresent(snapshotType -> this.selectBuilder.and("type", snapshotType.name()));
    }

    void addSnapshotPkFilter(long snapshotPk) {
        this.selectBuilder.and("snapshot_pk", snapshotPk);
    }

    void addGlobalIdFilter(long globalIdPk) {
        if (!this.queryParams.isAggregate()) {
            this.selectBuilder.and("g.global_id_pk", globalIdPk);
        } else {
            this.selectBuilder.and("( g.global_id_pk = ? OR g.owner_id_fk = ? )", Parameter.longParam(globalIdPk), Parameter.longParam(globalIdPk));
        }
    }

    void addSnapshotIdentifiersFilter(List<SnapshotDbIdentifier> snapshotDbIdentifiers) {
        this.selectBuilder.append("and (", new Parameter[0]);
        snapshotDbIdentifiers.forEach(si -> this.selectBuilder.append("(global_id_fk = ? AND version = ?) OR", Parameter.longParam(si.getGlobalIdPk()), Parameter.longParam(si.getVer())));
        this.selectBuilder.append(" false)", new Parameter[0]);
    }

    void addVoOwnerEntityFilter(String ownerTypeName, String fragment) {
        this.selectBuilder.and("o.type_name = ?", Parameter.stringParam(ownerTypeName)).and("g.fragment = ?", Parameter.stringParam(fragment));
    }

    void addManagedTypesFilter(Set<String> managedTypeNames) {
        String basePredicate = "managed_type in (" + ToStringBuilder.join(managedTypeNames) + ")";
        if (!this.queryParams.isAggregate()) {
            this.selectBuilder.and(basePredicate, new Parameter[0]);
        } else {
            this.selectBuilder.and("(  " + basePredicate + "  OR g.owner_id_fk in (      select g1." + "global_id_pk" + " from " + this.snapshotTableName() + " s1      INNER JOIN " + this.globalIdTableName() + " g1 ON g1." + "global_id_pk" + "= s1." + "global_id_fk" + "     and  s1." + basePredicate + "))", new Parameter[0]);
        }
    }

    List<CdoSnapshotSerialized> run() {
        this.selectBuilder.orderByDesc("snapshot_pk");
        this.selectBuilder.limit(this.queryParams.limit(), this.queryParams.skip());
        return this.selectBuilder.executeQuery(this.cdoSnapshotMapper);
    }

    private void addCommitPropertyFilter(SelectBuilder selectBuilder, String propertyName, String propertyValue) {
        selectBuilder.and("EXISTS ( SELECT * FROM " + this.commitPropertyTableName() + " WHERE " + "commit_fk" + " = " + "commit_pk" + " AND " + "property_name" + " = ? AND " + "property_value" + " = ?)", Parameter.stringParam(propertyName), Parameter.stringParam(propertyValue));
    }

    private String snapshotTableName() {
        return this.tableNameProvider.getSnapshotTableNameWithSchema();
    }

    private String globalIdTableName() {
        return this.tableNameProvider.getGlobalIdTableNameWithSchema();
    }

    private String commitPropertyTableName() {
        return this.tableNameProvider.getCommitPropertyTableNameWithSchema();
    }

    static class SnapshotDbIdentifier {
        private final long version;
        private final long globalIdPk;

        SnapshotDbIdentifier(SnapshotIdentifier snapshotIdentifier, long globalIdPk) {
            this.version = snapshotIdentifier.getVersion();
            this.globalIdPk = globalIdPk;
        }

        public long getGlobalIdPk() {
            return this.globalIdPk;
        }

        public long getVer() {
            return this.version;
        }
    }

    private static class CdoSnapshotMapper
    implements ObjectMapper<CdoSnapshotSerialized> {
        private CdoSnapshotMapper() {
        }

        @Override
        public CdoSnapshotSerialized get(ResultSet resultSet) throws SQLException {
            return new CdoSnapshotSerialized().withCommitAuthor(resultSet.getString("author")).withCommitDate((Date)resultSet.getTimestamp("commit_date")).withCommitDateInstant(resultSet.getString("commit_date_instant")).withCommitId(resultSet.getBigDecimal("commit_id")).withCommitPk(resultSet.getLong("commit_pk")).withVersion(resultSet.getLong("version")).withSnapshotState(resultSet.getString("state")).withChangedProperties(resultSet.getString("changed_properties")).withSnapshotType(resultSet.getString("type")).withGlobalIdFragment(resultSet.getString("fragment")).withGlobalIdLocalId(resultSet.getString("local_id")).withGlobalIdTypeName(resultSet.getString("managed_type")).withOwnerGlobalIdFragment(resultSet.getString("owner_fragment")).withOwnerGlobalIdLocalId(resultSet.getString("owner_local_id")).withOwnerGlobalIdTypeName(resultSet.getString("owner_type_name"));
        }
    }
}

