/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.SqlRepositoryConfiguration;
import org.javers.repository.sql.finders.CdoSnapshotFinder;
import org.javers.repository.sql.repositories.CdoSnapshotRepository;
import org.javers.repository.sql.repositories.CommitMetadataRepository;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.JaversSchemaManager;
import org.javers.repository.sql.session.Session;
import org.javers.repository.sql.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSqlRepository
implements JaversRepository {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.javers.SQL");
    private final SessionFactory sessionFactory;
    private final CommitMetadataRepository commitRepository;
    private final GlobalIdRepository globalIdRepository;
    private final CdoSnapshotRepository cdoSnapshotRepository;
    private final CdoSnapshotFinder finder;
    private final JaversSchemaManager schemaManager;
    private final SqlRepositoryConfiguration sqlRepositoryConfiguration;

    public JaversSqlRepository(SessionFactory sessionFactory, CommitMetadataRepository commitRepository, GlobalIdRepository globalIdRepository, CdoSnapshotRepository cdoSnapshotRepository, CdoSnapshotFinder finder, JaversSchemaManager schemaManager, SqlRepositoryConfiguration sqlRepositoryConfiguration) {
        this.sessionFactory = sessionFactory;
        this.commitRepository = commitRepository;
        this.globalIdRepository = globalIdRepository;
        this.cdoSnapshotRepository = cdoSnapshotRepository;
        this.finder = finder;
        this.schemaManager = schemaManager;
        this.sqlRepositoryConfiguration = sqlRepositoryConfiguration;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        try (Session session = this.sessionFactory.create("get latest snapshot");){
            Optional<CdoSnapshot> optional = this.finder.getLatest(globalId, session, true);
            return optional;
        }
    }

    public List<CdoSnapshot> getLatest(Collection<GlobalId> globalIds) {
        Validate.argumentIsNotNull(globalIds);
        try (Session session = this.sessionFactory.create("get latest snapshots");){
            List<CdoSnapshot> list = globalIds.stream().map(id -> this.finder.getLatest((GlobalId)id, session, false)).filter(it -> it.isPresent()).map(it -> (CdoSnapshot)it.get()).collect(Collectors.toList());
            return list;
        }
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        try (Session session = this.sessionFactory.create("find snapshots");){
            List<CdoSnapshot> list = this.finder.getSnapshots(queryParams, session);
            return list;
        }
    }

    public void persist(Commit commit) {
        try (Session session = this.sessionFactory.create("persist commit");){
            long commitPk = this.commitRepository.save(commit.getAuthor(), commit.getProperties(), commit.getCommitDate(), commit.getId(), session);
            this.cdoSnapshotRepository.save(commitPk, commit.getSnapshots(), session);
        }
    }

    public CommitId getHeadId() {
        try (Session session = this.sessionFactory.create("get head id");){
            CommitId commitId = this.commitRepository.getCommitHeadId(session);
            return commitId;
        }
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        try (Session session = this.sessionFactory.create("find snapshots by ids");){
            List<CdoSnapshot> list = this.finder.getSnapshots(snapshotIdentifiers, session);
            return list;
        }
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        try (Session session = this.sessionFactory.create("find snapshots by globalId");){
            List<CdoSnapshot> list = this.finder.getStateHistory(globalId, queryParams, session);
            return list;
        }
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        try (Session session = this.sessionFactory.create("find snapshots by type");){
            List<CdoSnapshot> list = this.finder.getStateHistory(givenClasses, queryParams, session);
            return list;
        }
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        try (Session session = this.sessionFactory.create("find VO snapshots by path");){
            List<CdoSnapshot> list = this.finder.getVOStateHistory(ownerEntity, path, queryParams, session);
            return list;
        }
    }

    public void evictCache() {
        this.globalIdRepository.evictCache();
    }

    public int getGlobalIdPkCacheSize() {
        return this.globalIdRepository.getGlobalIdPkCacheSize();
    }

    public SqlRepositoryConfiguration getConfiguration() {
        return this.sqlRepositoryConfiguration;
    }

    public void evictSequenceAllocationCache() {
        this.sessionFactory.resetKeyGeneratorCache();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.globalIdRepository.setJsonConverter(jsonConverter);
        this.cdoSnapshotRepository.setJsonConverter(jsonConverter);
        this.finder.setJsonConverter(jsonConverter);
    }

    public void ensureSchema() {
        if (this.sqlRepositoryConfiguration.isSchemaManagementEnabled()) {
            this.schemaManager.ensureSchema();
        }
    }
}

