/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.time.LocalDateTime;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.commit.CommitId;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.repository.api.QueryParams;
import org.javers.repository.sql.schema.SchemaNameAware;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

abstract class SnapshotFilter
extends SchemaNameAware {
    private static final String BASE_FIELDS = "state, type, version, changed_properties, managed_type, commit_pk, author, commit_date, commit_id";
    static final String BASE_AND_GLOBAL_ID_FIELDS = "state, type, version, changed_properties, managed_type, commit_pk, author, commit_date, commit_id, g.local_id, g.fragment, g.owner_id_fk, o.local_id owner_local_id, o.fragment owner_fragment, o.type_name owner_type_name";

    SnapshotFilter(TableNameProvider tableNameProvider) {
        super(tableNameProvider);
    }

    protected String getFromCommitWithSnapshot() {
        return this.getSnapshotTableNameWithSchema() + " INNER JOIN " + this.getCommitTableNameWithSchema() + " ON " + "commit_pk" + " = " + "commit_fk" + " INNER JOIN " + this.getGlobalIdTableNameWithSchema() + " g ON g." + "global_id_pk" + " = " + "global_id_fk" + " LEFT OUTER JOIN " + this.getGlobalIdTableNameWithSchema() + " o ON o." + "global_id_pk" + " = g." + "owner_id_fk";
    }

    String select() {
        return BASE_AND_GLOBAL_ID_FIELDS;
    }

    void addFrom(SelectQuery query) {
        query.from(this.getFromCommitWithSnapshot());
    }

    abstract void addWhere(SelectQuery var1);

    void applyQueryParams(SelectQuery query, QueryParams queryParams) {
        if (queryParams.changedProperty().isPresent()) {
            this.addChangedPropertyCondition(query, (String)queryParams.changedProperty().get());
        }
        if (queryParams.from().isPresent()) {
            this.addFromDateCondition(query, (LocalDateTime)queryParams.from().get());
        }
        if (queryParams.to().isPresent()) {
            this.addToDateCondition(query, (LocalDateTime)queryParams.to().get());
        }
        if (queryParams.toCommitId().isPresent()) {
            this.addToCommitIdCondition(query, (CommitId)queryParams.toCommitId().get());
        }
        if (queryParams.commitIds().size() > 0) {
            this.addCommitIdCondition(query, queryParams.commitIds());
        }
        if (queryParams.version().isPresent()) {
            this.addVersionCondition(query, (Long)queryParams.version().get());
        }
        if (queryParams.author().isPresent()) {
            this.addAuthorCondition(query, (String)queryParams.author().get());
        }
        if (queryParams.commitProperties().size() > 0) {
            this.addCommitPropertyConditions(query, queryParams.commitProperties());
        }
        query.limit(queryParams.limit(), queryParams.skip());
    }

    private void addChangedPropertyCondition(SelectQuery query, String changedProperty) {
        query.append(" AND changed_properties like '%\"" + changedProperty + "\"%'");
    }

    private void addFromDateCondition(SelectQuery query, LocalDateTime from) {
        query.append(" AND commit_date >= :commitFromDate").withArgument("commitFromDate", (Object)new Timestamp(UtilTypeCoreAdapters.toUtilDate((LocalDateTime)from)));
    }

    private void addToDateCondition(SelectQuery query, LocalDateTime to) {
        query.append(" AND commit_date <= :commitToDate").withArgument("commitToDate", (Object)new Timestamp(UtilTypeCoreAdapters.toUtilDate((LocalDateTime)to)));
    }

    private void addCommitIdCondition(SelectQuery query, Set<CommitId> commitIds) {
        query.append(" AND commit_id IN (" + ToStringBuilder.join(commitIds.stream().map(c -> c.valueAsNumber()).collect(Collectors.toList())) + ")");
    }

    private void addToCommitIdCondition(SelectQuery query, CommitId commitId) {
        query.append(" AND commit_id <= " + commitId.valueAsNumber());
    }

    void addVersionCondition(SelectQuery query, Long version) {
        query.append(" AND version = :version").withArgument("version", (Object)version);
    }

    private void addAuthorCondition(SelectQuery query, String author) {
        query.append(" AND author = :author").withArgument("author", (Object)author);
    }

    private void addCommitPropertyConditions(SelectQuery query, Map<String, String> commitProperties) {
        for (Map.Entry<String, String> commitProperty : commitProperties.entrySet()) {
            this.addCommitPropertyCondition(query, commitProperty.getKey(), commitProperty.getValue());
        }
    }

    private void addCommitPropertyCondition(SelectQuery query, String propertyName, String propertyValue) {
        query.append(" AND EXISTS (SELECT * FROM " + this.getCommitPropertyTableNameWithSchema() + " WHERE " + "commit_fk" + " = " + "commit_pk" + " AND " + "property_name" + " = :propertyName_" + propertyName + " AND " + "property_value" + " = :propertyValue_" + propertyName + ")").withArgument("propertyName_" + propertyName, (Object)propertyName).withArgument("propertyValue_" + propertyName, (Object)propertyValue);
    }
}

