/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Set;
import org.javers.common.string.ToStringBuilder;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.query.SelectQuery;

class ManagedClassFilter
extends SnapshotFilter {
    private final Set<String> managedTypes;
    private final boolean aggregate;

    ManagedClassFilter(TableNameProvider tableNameProvider, Set<String> managedTypes, boolean aggregate) {
        super(tableNameProvider);
        this.managedTypes = managedTypes;
        this.aggregate = aggregate;
    }

    @Override
    void addWhere(SelectQuery query) {
        String condition = this.getCondition();
        if (!this.aggregate) {
            query.where(condition);
        } else {
            query.where("(    " + condition + "  OR g.owner_id_fk in (      select g1." + "global_id_pk" + " from " + this.getSnapshotTableNameWithSchema() + " s1      INNER JOIN " + this.getGlobalIdTableNameWithSchema() + " g1 ON g1." + "global_id_pk" + "= s1." + "global_id_fk" + "     and  s1." + condition + "))");
        }
    }

    private String getCondition() {
        return "managed_type in (" + ToStringBuilder.join(this.managedTypes) + ")";
    }
}

