/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Pair;
import org.javers.common.collections.Sets;
import org.javers.core.json.CdoSnapshotSerialized;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.sql.PolyUtil;
import org.javers.repository.sql.finders.AnySnapshotFilter;
import org.javers.repository.sql.finders.CdoSnapshotMapper;
import org.javers.repository.sql.finders.CdoSnapshotsEnricher;
import org.javers.repository.sql.finders.CommitPropertyDTO;
import org.javers.repository.sql.finders.CommitPropertyFinder;
import org.javers.repository.sql.finders.GlobalIdFilter;
import org.javers.repository.sql.finders.ManagedClassFilter;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.javers.repository.sql.finders.SnapshotIdFilter;
import org.javers.repository.sql.finders.SnapshotIdentifiersFilter;
import org.javers.repository.sql.finders.VoOwnerEntityFilter;
import org.javers.repository.sql.repositories.GlobalIdRepository;
import org.javers.repository.sql.schema.TableNameProvider;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.Order;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.query.mapper.ObjectMapper;

public class CdoSnapshotFinder {
    private final PolyJDBC polyJDBC;
    private final GlobalIdRepository globalIdRepository;
    private final CommitPropertyFinder commitPropertyFinder;
    private final CdoSnapshotMapper cdoSnapshotMapper;
    private final CdoSnapshotsEnricher cdoSnapshotsEnricher = new CdoSnapshotsEnricher();
    private JsonConverter jsonConverter;
    private final TableNameProvider tableNameProvider;

    public CdoSnapshotFinder(PolyJDBC polyJDBC, GlobalIdRepository globalIdRepository, CommitPropertyFinder commitPropertyFinder, TableNameProvider tableNameProvider) {
        this.polyJDBC = polyJDBC;
        this.globalIdRepository = globalIdRepository;
        this.commitPropertyFinder = commitPropertyFinder;
        this.cdoSnapshotMapper = new CdoSnapshotMapper();
        this.tableNameProvider = tableNameProvider;
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        if (!globalIdPk.isPresent()) {
            return Optional.empty();
        }
        return this.selectMaxSnapshotPrimaryKey(globalIdPk.get()).map(maxSnapshot -> {
            QueryParams oneItemLimit = QueryParamsBuilder.withLimit((int)1).build();
            return this.fetchCdoSnapshots(new SnapshotIdFilter(this.tableNameProvider, (long)maxSnapshot), Optional.of(oneItemLimit)).get(0);
        });
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.fetchCdoSnapshots(new AnySnapshotFilter(this.tableNameProvider), Optional.of(queryParams));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return this.fetchCdoSnapshots(new SnapshotIdentifiersFilter(this.tableNameProvider, this.globalIdRepository, snapshotIdentifiers), Optional.empty());
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> managedTypes, QueryParams queryParams) {
        Set managedTypeNames = Sets.transform(managedTypes, managedType -> managedType.getName());
        ManagedClassFilter classFilter = new ManagedClassFilter(this.tableNameProvider, managedTypeNames, queryParams.isAggregate());
        return this.fetchCdoSnapshots(classFilter, Optional.of(queryParams));
    }

    public List<CdoSnapshot> getVOStateHistory(EntityType ownerEntity, String fragment, QueryParams queryParams) {
        VoOwnerEntityFilter voOwnerFilter = new VoOwnerEntityFilter(this.tableNameProvider, ownerEntity.getName(), fragment);
        return this.fetchCdoSnapshots(voOwnerFilter, Optional.of(queryParams));
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Optional<Long> globalIdPk = this.globalIdRepository.findGlobalIdPk(globalId);
        return globalIdPk.map(id -> this.fetchCdoSnapshots(new GlobalIdFilter(this.tableNameProvider, (long)id, queryParams.isAggregate()), Optional.of(queryParams))).orElse(Collections.emptyList());
    }

    private List<CdoSnapshot> fetchCdoSnapshots(SnapshotFilter snapshotFilter, Optional<QueryParams> queryParams) {
        List<Pair<CdoSnapshotSerialized, Long>> serializedSnapshots = this.queryForCdoSnapshotDTOs(snapshotFilter, queryParams);
        List<CommitPropertyDTO> commitPropertyDTOs = this.commitPropertyFinder.findCommitPropertiesOfSnaphots(Pair.collectRightAsSet(serializedSnapshots));
        this.cdoSnapshotsEnricher.enrichWithCommitProperties(serializedSnapshots, commitPropertyDTOs);
        return Lists.transform(serializedSnapshots, serializedSnapshot -> this.jsonConverter.fromSerializedSnapshot((CdoSnapshotSerialized)serializedSnapshot.left()));
    }

    private List<Pair<CdoSnapshotSerialized, Long>> queryForCdoSnapshotDTOs(SnapshotFilter snapshotFilter, Optional<QueryParams> queryParams) {
        SelectQuery query = this.polyJDBC.query().select(snapshotFilter.select());
        snapshotFilter.addFrom(query);
        snapshotFilter.addWhere(query);
        if (queryParams.isPresent()) {
            snapshotFilter.applyQueryParams(query, queryParams.get());
        }
        query.orderBy("snapshot_pk", Order.DESC);
        return this.polyJDBC.queryRunner().queryList(query, (ObjectMapper)this.cdoSnapshotMapper);
    }

    private Optional<Long> selectMaxSnapshotPrimaryKey(long globalIdPk) {
        SelectQuery query = this.polyJDBC.query().select("MAX(snapshot_pk)").from(this.tableNameProvider.getSnapshotTableNameWithSchema()).where("global_id_fk = :globalIdPk").withArgument("globalIdPk", (Object)globalIdPk);
        Optional<Long> result = PolyUtil.queryForOptionalLong(query, this.polyJDBC);
        if (result.isPresent() && result.get() == 0L) {
            return Optional.empty();
        }
        return result;
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }
}

