/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.reposiotries;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.javers.common.collections.Optional;
import org.javers.core.json.JsonConverter;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.UnboundedValueObjectId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.repository.sql.PolyUtil;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;

public class GlobalIdRepository {
    private PolyJDBC polyJdbc;
    private JsonConverter jsonConverter;
    private Cache<GlobalId, Long> globalIdPkCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public GlobalIdRepository(PolyJDBC javersPolyjdbc) {
        this.polyJdbc = javersPolyjdbc;
    }

    public long getOrInsertId(GlobalId globalId) {
        Optional<Long> pk = this.findGlobalIdPk(globalId);
        return pk.isPresent() ? ((Long)pk.get()).longValue() : this.insert(globalId);
    }

    public long getOrInsertClass(GlobalId globalId) {
        String typeName = globalId.getTypeName();
        Optional<Long> lookup = this.findClassPk(typeName);
        return lookup.isPresent() ? ((Long)lookup.get()).longValue() : this.insertClass(typeName);
    }

    public Optional<Long> findClassPk(String typeName) {
        SelectQuery query = this.polyJdbc.query().select("cdo_class_pk").from("jv_cdo_class").where("qualified_name = :qualifiedName ").withArgument("qualifiedName", (Object)typeName);
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    public Optional<Long> findGlobalIdPk(GlobalId globalId) {
        Long foundPk = (Long)this.globalIdPkCache.getIfPresent((Object)globalId);
        if (foundPk != null) {
            return Optional.of((Object)foundPk);
        }
        Optional<Long> fresh = this.findGlobalIdPkRaw(globalId);
        if (fresh.isPresent()) {
            this.globalIdPkCache.put((Object)globalId, fresh.get());
        }
        return fresh;
    }

    private Optional<Long> findGlobalIdPkRaw(GlobalId globalId) {
        String GLOBAL_ID_WITH_CDO_CLASS = "jv_global_id g INNER JOIN jv_cdo_class c ON cdo_class_pk = cdo_class_fk";
        SelectQuery query = this.polyJdbc.query().select("global_id_pk");
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            Optional<Long> ownerFk = this.findGlobalIdPk(valueObjectId.getOwnerId());
            if (ownerFk.isEmpty()) {
                return Optional.empty();
            }
            query.from("jv_global_id g INNER JOIN jv_cdo_class c ON cdo_class_pk = cdo_class_fk").where("fragment = :fragment AND owner_id_fk = :ownerFk AND c.qualified_name = :voQualifiedName ").withArgument("fragment", (Object)valueObjectId.getFragment()).withArgument("voQualifiedName", (Object)valueObjectId.getTypeName()).withArgument("ownerFk", ownerFk.get());
        } else if (globalId instanceof InstanceId) {
            query.from("jv_global_id g INNER JOIN jv_cdo_class c ON cdo_class_pk = cdo_class_fk").where("g.local_id = :localId AND c.qualified_name = :qualifiedName ").withArgument("localId", (Object)this.jsonConverter.toJson(((InstanceId)globalId).getCdoId())).withArgument("qualifiedName", (Object)globalId.getTypeName());
        } else if (globalId instanceof UnboundedValueObjectId) {
            query.from("jv_global_id g INNER JOIN jv_cdo_class c ON cdo_class_pk = cdo_class_fk").where("c.qualified_name = :qualifiedName ").withArgument("qualifiedName", (Object)globalId.getTypeName());
        }
        return PolyUtil.queryForOptionalLong(query, this.polyJdbc);
    }

    private long insert(GlobalId globalId) {
        long classPk = this.getOrInsertClass(globalId);
        InsertQuery query = this.polyJdbc.query().insert().into("jv_global_id");
        query.value("cdo_class_fk", (Object)classPk);
        if (globalId instanceof ValueObjectId) {
            ValueObjectId valueObjectId = (ValueObjectId)globalId;
            long ownerFk = this.getOrInsertId(valueObjectId.getOwnerId());
            query.value("fragment", (Object)valueObjectId.getFragment()).value("owner_id_fk", (Object)ownerFk);
        } else if (globalId instanceof InstanceId) {
            query.value("local_id", (Object)this.jsonConverter.toJson(((InstanceId)globalId).getCdoId()));
        }
        query.sequence("global_id_pk", "jv_global_id_pk_seq");
        long globalIdPk = this.polyJdbc.queryRunner().insert(query);
        return globalIdPk;
    }

    private long insertClass(String typeName) {
        InsertQuery query = this.polyJdbc.query().insert().into("jv_cdo_class").value("qualified_name", (Object)typeName).sequence("cdo_class_pk", "jv_cdo_class_pk_seq");
        return this.polyJdbc.queryRunner().insert(query);
    }

    public void setJsonConverter(JsonConverter JSONConverter) {
        this.jsonConverter = JSONConverter;
    }
}

