/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.reposiotries;

import java.math.BigDecimal;
import java.util.TimeZone;
import org.javers.common.collections.Optional;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.repository.sql.PolyUtil;
import org.joda.time.LocalDateTime;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.query.InsertQuery;
import org.polyjdbc.core.query.SelectQuery;
import org.polyjdbc.core.type.Timestamp;

public class CommitMetadataRepository {
    private final PolyJDBC polyJDBC;

    public CommitMetadataRepository(PolyJDBC polyjdbc) {
        this.polyJDBC = polyjdbc;
    }

    public long save(String author, LocalDateTime date, CommitId commitId) {
        InsertQuery query = this.polyJDBC.query().insert().into("jv_commit").value("author", (Object)author).value("commit_date", (Object)this.toTimestamp(date)).value("commit_id", (Object)commitId.valueAsNumber()).sequence("commit_pk", "jv_commit_pk_seq");
        return this.polyJDBC.queryRunner().insert(query);
    }

    public boolean isPersisted(Commit commit) {
        SelectQuery selectQuery = this.polyJDBC.query().select("count(*)").from("jv_commit").where("commit_id = :id").withArgument("id", (Object)commit.getId().valueAsNumber());
        return (Long)PolyUtil.queryForOptionalLong(selectQuery, this.polyJDBC).get() > 0L;
    }

    private Timestamp toTimestamp(LocalDateTime commitMetadata) {
        return new Timestamp(commitMetadata.toDate(TimeZone.getTimeZone("UTC")));
    }

    public CommitId getCommitHeadId() {
        Optional<BigDecimal> maxCommitId = this.selectMaxCommitId();
        return maxCommitId.isEmpty() ? null : CommitId.valueOf((BigDecimal)((BigDecimal)maxCommitId.get()));
    }

    private Optional<BigDecimal> selectMaxCommitId() {
        SelectQuery query = this.polyJDBC.query().select("MAX(commit_id)").from("jv_commit");
        return PolyUtil.queryForOptionalBigDecimal(query, this.polyJDBC);
    }
}

