/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.schema;

import java.io.Closeable;
import java.util.Map;
import org.javers.repository.sql.schema.FixedSchemaFactory;
import org.polyjdbc.core.PolyJDBC;
import org.polyjdbc.core.dialect.Dialect;
import org.polyjdbc.core.schema.SchemaInspector;
import org.polyjdbc.core.schema.SchemaManager;
import org.polyjdbc.core.schema.model.Schema;
import org.polyjdbc.core.util.TheCloser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaversSchemaManager {
    private static final Logger logger = LoggerFactory.getLogger(JaversSchemaManager.class);
    private SchemaInspector schemaInspector;
    private SchemaManager schemaManager;
    private final Dialect dialect;
    private final FixedSchemaFactory schemaFactory;
    private final PolyJDBC polyJDBC;

    public JaversSchemaManager(Dialect dialect, FixedSchemaFactory fixedSchemaFactory, PolyJDBC polyJDBC) {
        this.dialect = dialect;
        this.schemaFactory = fixedSchemaFactory;
        this.polyJDBC = polyJDBC;
    }

    public void ensureSchema() {
        this.schemaInspector = this.polyJDBC.schemaInspector();
        this.schemaManager = this.polyJDBC.schemaManager();
        for (Map.Entry<String, Schema> e : this.schemaFactory.allTablesSchema(this.dialect).entrySet()) {
            this.ensureTable(e.getKey(), e.getValue());
        }
        TheCloser.close((Closeable[])new Closeable[]{this.schemaManager, this.schemaInspector});
    }

    private void ensureTable(String tableName, Schema schema) {
        if (this.schemaInspector.relationExists(tableName)) {
            return;
        }
        logger.info("creating javers table {} ...", (Object)tableName);
        this.schemaManager.create(schema);
    }

    public void dropSchema() {
        throw new RuntimeException("not implemented");
    }
}

