/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql.finders;

import org.javers.common.collections.Optional;
import org.javers.repository.sql.finders.SnapshotFilter;
import org.polyjdbc.core.query.SelectQuery;

class ManagedClassFilter
extends SnapshotFilter {
    ManagedClassFilter(long classPk, Optional<String> propertyName) {
        super(classPk, "g.cdo_class_fk", propertyName);
    }

    ManagedClassFilter(long classPk, String pkFieldName) {
        super(classPk, pkFieldName, (Optional<String>)Optional.empty());
    }

    @Override
    String select() {
        return "state, type, changed_properties, author, commit_date, commit_id, g.local_id, g.fragment, g.owner_id_fk, g_c.qualified_name, o.local_id as owner_local_id, o.fragment as owner_fragment, o_c.qualified_name as owner_qualified_name";
    }

    @Override
    void addFrom(SelectQuery query) {
        String JOIN_GLOBAL_ID_TO_SNAPSHOT = " INNER JOIN jv_global_id as g ON g.global_id_pk = global_id_fk INNER JOIN jv_cdo_class as g_c ON g_c.cdo_class_pk = g.cdo_class_fk LEFT OUTER JOIN jv_global_id as o ON o.global_id_pk = g.owner_id_fk LEFT OUTER JOIN jv_cdo_class as o_c ON o_c.cdo_class_pk = o.cdo_class_fk";
        query.from("jv_snapshot INNER JOIN jv_commit ON commit_pk = commit_fk INNER JOIN jv_global_id as g ON g.global_id_pk = global_id_fk INNER JOIN jv_cdo_class as g_c ON g_c.cdo_class_pk = g.cdo_class_fk LEFT OUTER JOIN jv_global_id as o ON o.global_id_pk = g.owner_id_fk LEFT OUTER JOIN jv_cdo_class as o_c ON o_c.cdo_class_pk = o.cdo_class_fk");
    }
}

