/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.sql;

import org.javers.core.AbstractJaversBuilder;
import org.javers.repository.sql.ConnectionProvider;
import org.javers.repository.sql.DialectName;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.repository.sql.pico.JaversSqlModule;
import org.javers.repository.sql.schema.JaversSchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRepositoryBuilder
extends AbstractJaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(SqlRepositoryBuilder.class);
    private DialectName dialectName;
    private ConnectionProvider connectionProvider;

    private SqlRepositoryBuilder() {
    }

    public static SqlRepositoryBuilder sqlRepository() {
        return new SqlRepositoryBuilder();
    }

    public SqlRepositoryBuilder withDialect(DialectName dialect) {
        this.dialectName = dialect;
        return this;
    }

    public SqlRepositoryBuilder withConnectionProvider(ConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
        return this;
    }

    public JaversSqlRepository build() {
        logger.info("starting up SQL repository module ...");
        this.bootContainer();
        this.addModule(new JaversSqlModule());
        this.addComponent(this.dialectName.getPolyDialect());
        this.addComponent((Object)this.dialectName);
        this.addComponent(this.connectionProvider);
        this.ensureSchema();
        return this.getContainerComponent(JaversSqlRepository.class);
    }

    private void ensureSchema() {
        JaversSchemaManager schemaManager = this.getContainerComponent(JaversSchemaManager.class);
        schemaManager.ensureSchema();
    }

    protected <T> T getContainerComponent(Class<T> ofClass) {
        return (T)super.getContainerComponent(ofClass);
    }
}

