/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import java.util.Optional;
import org.javers.repository.mongo.MongoDialect;

class MongoRepositoryConfiguration {
    private static final String DEFAULT_SNAPSHOT_COLLECTION_NAME = "jv_snapshots";
    private static final String DEFAULT_HEAD_COLLECTION_NAME = "jv_head_id";
    private static final int DEFAULT_CACHE_SIZE = 5000;
    private static final MongoDialect DEFAULT_MONGO_DIALECT = MongoDialect.MONGO_DB;
    private final String snapshotCollectionName;
    private final String headCollectionName;
    private final Integer cacheSize;
    private final MongoDialect mongoDialect;
    private final boolean schemaManagementEnabled;

    MongoRepositoryConfiguration(String snapshotCollectionName, String headCollectionName, Integer cacheSize, MongoDialect mongoDialect, boolean schemaManagementEnabled) {
        this.snapshotCollectionName = snapshotCollectionName;
        this.headCollectionName = headCollectionName;
        this.cacheSize = cacheSize;
        this.mongoDialect = mongoDialect;
        this.schemaManagementEnabled = schemaManagementEnabled;
    }

    String getSnapshotCollectionName() {
        return Optional.ofNullable(this.snapshotCollectionName).orElse(DEFAULT_SNAPSHOT_COLLECTION_NAME);
    }

    String getHeadCollectionName() {
        return Optional.ofNullable(this.headCollectionName).orElse(DEFAULT_HEAD_COLLECTION_NAME);
    }

    Integer getCacheSize() {
        return Optional.ofNullable(this.cacheSize).orElse(5000);
    }

    MongoDialect getMongoDialect() {
        return Optional.ofNullable(this.mongoDialect).orElse(DEFAULT_MONGO_DIALECT);
    }

    boolean isSchemaManagementEnabled() {
        return this.schemaManagementEnabled;
    }
}

