/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.google.gson.JsonObject;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.javers.common.collections.Lists;
import org.javers.common.string.RegexEscape;
import org.javers.common.validation.Validate;
import org.javers.core.CommitIdGenerator;
import org.javers.core.JaversCoreConfiguration;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.SnapshotType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.api.ConfigurationAware;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.mongo.DocumentConverter;
import org.javers.repository.mongo.LatestSnapshotCache;
import org.javers.repository.mongo.MapKeyDotReplacer;
import org.javers.repository.mongo.MongoDialect;
import org.javers.repository.mongo.MongoSchemaManager;
import org.javers.repository.mongo.model.MongoHeadId;

public class MongoRepository
implements JaversRepository,
ConfigurationAware {
    private static final int DEFAULT_CACHE_SIZE = 5000;
    private static final double COMMIT_ID_PRECISION = 0.005;
    private static final int DESC = -1;
    private final MongoSchemaManager mongoSchemaManager;
    private JsonConverter jsonConverter;
    private JaversCoreConfiguration coreConfiguration;
    private final MapKeyDotReplacer mapKeyDotReplacer = new MapKeyDotReplacer();
    private final LatestSnapshotCache cache;
    private MongoDialect mongoDialect;

    public MongoRepository(MongoDatabase mongo) {
        this(mongo, 5000, MongoDialect.MONGO_DB);
    }

    public static MongoRepository mongoRepositoryWithDocumentDBCompatibility(MongoDatabase mongo, int cacheSize) {
        return new MongoRepository(mongo, cacheSize, MongoDialect.DOCUMENT_DB);
    }

    public MongoRepository(MongoDatabase mongo, int cacheSize) {
        this(mongo, cacheSize, MongoDialect.MONGO_DB);
    }

    MongoRepository(MongoDatabase mongo, int cacheSize, MongoDialect dialect) {
        Validate.argumentsAreNotNull((Object[])new Object[]{mongo, dialect});
        this.mongoDialect = dialect;
        this.mongoSchemaManager = new MongoSchemaManager(mongo);
        this.cache = new LatestSnapshotCache(cacheSize, input -> this.getLatest(this.createIdQuery((GlobalId)input)));
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    void clean() {
        this.snapshotsCollection().deleteMany((Bson)new Document());
        this.headCollection().deleteMany((Bson)new Document());
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Bson query = queryParams.isAggregate() ? this.createIdQueryWithAggregate(globalId) : this.createIdQuery(globalId);
        return this.queryForSnapshots(query, Optional.of(queryParams));
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.cache.getLatest(globalId);
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.queryForSnapshots((Bson)new BasicDBObject(), Optional.of(queryParams));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return snapshotIdentifiers.isEmpty() ? Collections.emptyList() : this.queryForSnapshots(this.createSnapshotIdentifiersQuery(snapshotIdentifiers), Optional.empty());
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        BasicDBObject query = new BasicDBObject("globalId.ownerId.entity", (Object)ownerEntity.getName());
        query.append("globalId.fragment", (Object)path);
        return this.queryForSnapshots((Bson)query, Optional.of(queryParams));
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Bson query = this.createManagedTypeQuery(givenClasses, queryParams.isAggregate());
        return this.queryForSnapshots(query, Optional.of(queryParams));
    }

    public CommitId getHeadId() {
        Document headId = (Document)this.headCollection().find().first();
        if (headId == null) {
            return null;
        }
        return new MongoHeadId(headId).toCommitId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void setConfiguration(JaversCoreConfiguration coreConfiguration) {
        this.coreConfiguration = coreConfiguration;
    }

    public void ensureSchema() {
        this.mongoSchemaManager.ensureSchema(this.mongoDialect);
    }

    private Bson createIdQuery(GlobalId id) {
        return new BasicDBObject("globalId_key", (Object)id.value());
    }

    private Bson createIdQueryWithAggregate(GlobalId id) {
        return Filters.or((Bson[])new Bson[]{this.createIdQuery(id), MongoRepository.prefixQuery("globalId_key", id.value() + "#")});
    }

    private Bson createVersionQuery(Long version) {
        return new BasicDBObject("version", (Object)version);
    }

    private Bson createSnapshotIdentifiersQuery(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        List descFilters = (List)snapshotIdentifiers.stream().map(snapshotIdentifier -> Filters.and((Bson[])new Bson[]{this.createIdQuery(snapshotIdentifier.getGlobalId()), this.createVersionQuery(snapshotIdentifier.getVersion())})).collect(Lists.toImmutableList());
        return Filters.or((Iterable)descFilters);
    }

    private Bson createManagedTypeQuery(Set<ManagedType> managedTypes, boolean aggregate) {
        List classFilters = (List)managedTypes.stream().map(managedType -> {
            if (managedType instanceof ValueObjectType) {
                return this.createValueObjectTypeQuery((ManagedType)managedType);
            }
            return this.createEntityTypeQuery(aggregate, (ManagedType)managedType);
        }).collect(Lists.toImmutableList());
        return Filters.or((Iterable)classFilters);
    }

    private Bson createValueObjectTypeQuery(ManagedType managedType) {
        return new BasicDBObject("globalId.valueObject", (Object)managedType.getName());
    }

    private Bson createEntityTypeQuery(boolean aggregate, ManagedType managedType) {
        Bson entityTypeQuery = MongoRepository.prefixQuery("globalId_key", managedType.getName() + "/");
        if (!aggregate) {
            entityTypeQuery = Filters.and((Bson[])new Bson[]{entityTypeQuery, Filters.exists((String)"globalId.entity")});
        }
        return entityTypeQuery;
    }

    private CdoSnapshot readFromDBObject(Document dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(DocumentConverter.fromDocument(this.mapKeyDotReplacer.back(dbObject)), CdoSnapshot.class);
    }

    private Document writeToDBObject(CdoSnapshot snapshot) {
        Validate.conditionFulfilled((this.jsonConverter != null ? 1 : 0) != 0, (String)"MongoRepository: jsonConverter is null");
        Document dbObject = DocumentConverter.toDocument((JsonObject)this.jsonConverter.toJsonElement((Object)snapshot));
        dbObject = this.mapKeyDotReplacer.replaceInSnapshotState(dbObject);
        dbObject.append("globalId_key", (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private MongoCollection<Document> snapshotsCollection() {
        return this.mongoSchemaManager.snapshotsCollection();
    }

    private MongoCollection<Document> headCollection() {
        return this.mongoSchemaManager.headCollection();
    }

    private void persistSnapshots(Commit commit) {
        MongoCollection<Document> collection = this.snapshotsCollection();
        commit.getSnapshots().forEach(snapshot -> {
            collection.insertOne((Object)this.writeToDBObject((CdoSnapshot)snapshot));
            this.cache.put((CdoSnapshot)snapshot);
        });
    }

    private void persistHeadId(Commit commit) {
        MongoCollection<Document> headIdCollection = this.headCollection();
        Document oldHead = (Document)headIdCollection.find().first();
        MongoHeadId newHeadId = new MongoHeadId(commit.getId());
        if (oldHead == null) {
            headIdCollection.insertOne((Object)newHeadId.toDocument());
        } else {
            headIdCollection.updateOne(this.objectIdFiler(oldHead), (Bson)newHeadId.getUpdateCommand());
        }
    }

    private Bson objectIdFiler(Document document) {
        return Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id"));
    }

    private MongoCursor<Document> getMongoSnapshotsCursor(Bson query, Optional<QueryParams> queryParams) {
        FindIterable findIterable = this.snapshotsCollection().find(this.applyQueryParams(query, queryParams));
        if (this.coreConfiguration.getCommitIdGenerator() == CommitIdGenerator.SYNCHRONIZED_SEQUENCE) {
            findIterable.sort((Bson)new Document("commitMetadata.id", (Object)-1));
        } else {
            findIterable.sort((Bson)new Document("commitMetadata.commitDateInstant", (Object)-1));
        }
        return this.applyQueryParams((FindIterable<Document>)findIterable, queryParams).iterator();
    }

    private Bson applyQueryParams(Bson query, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = queryParams.get();
            if (params.from().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.gte((String)"commitMetadata.commitDate", (Object)UtilTypeCoreAdapters.serialize((LocalDateTime)((LocalDateTime)params.from().get())))});
            }
            if (params.fromInstant().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.gte((String)"commitMetadata.commitDateInstant", (Object)UtilTypeCoreAdapters.serialize((Instant)((Instant)params.fromInstant().get())))});
            }
            if (params.to().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.commitDate", (Object)UtilTypeCoreAdapters.serialize((LocalDateTime)((LocalDateTime)params.to().get())))});
            }
            if (params.toInstant().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.commitDateInstant", (Object)UtilTypeCoreAdapters.serialize((Instant)((Instant)params.toInstant().get())))});
            }
            if (params.toCommitId().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.id", (Object)(((CommitId)params.toCommitId().get()).valueAsNumber().doubleValue() + 0.005))});
            }
            if (params.commitIds().size() > 0) {
                query = Filters.or((Iterable)params.commitIds().stream().map(it -> this.commitIdFilter((CommitId)it)).collect(Collectors.toList()));
            }
            if (params.version().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, this.createVersionQuery((Long)params.version().get())});
            }
            if (params.author().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, new BasicDBObject("commitMetadata.author", params.author().get())});
            }
            if (!params.commitProperties().isEmpty()) {
                query = this.addCommitPropertiesFilter(query, params.commitProperties());
            }
            if (params.changedProperties().size() > 0) {
                query = Filters.and((Bson[])new Bson[]{query, Filters.or((Iterable)params.changedProperties().stream().map(it -> new BasicDBObject("changedProperties", it)).collect(Collectors.toList()))});
            }
            if (params.snapshotType().isPresent()) {
                query = Filters.and((Bson[])new Bson[]{query, new BasicDBObject("type", (Object)((SnapshotType)params.snapshotType().get()).name())});
            }
        }
        return query;
    }

    private Bson commitIdFilter(CommitId commitId) {
        if (commitId.getMinorId() > 0) {
            commitId.valueAsNumber().doubleValue();
            return Filters.and((Bson[])new Bson[]{Filters.gte((String)"commitMetadata.id", (Object)(commitId.valueAsNumber().doubleValue() - 0.005)), Filters.lte((String)"commitMetadata.id", (Object)(commitId.valueAsNumber().doubleValue() + 0.005))});
        }
        return Filters.eq((String)"commitMetadata.id", (Object)commitId.getMajorId());
    }

    private FindIterable<Document> applyQueryParams(FindIterable<Document> findIterable, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = queryParams.get();
            findIterable = findIterable.limit(params.limit()).skip(params.skip());
        }
        return findIterable;
    }

    private Bson addCommitPropertiesFilter(Bson query, Map<String, String> commitProperties) {
        List propertyFilters = (List)commitProperties.entrySet().stream().map(commitProperty -> new BasicDBObject("commitMetadata.properties", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("key", commitProperty.getKey()).append("value", commitProperty.getValue())))).collect(Lists.toImmutableList());
        return Filters.and((Bson[])new Bson[]{query, Filters.and((Bson[])propertyFilters.toArray(new Bson[0]))});
    }

    private Optional<CdoSnapshot> getLatest(Bson idQuery) {
        QueryParams queryParams = QueryParamsBuilder.withLimit((int)1).build();
        MongoCursor<Document> mongoLatest = this.getMongoSnapshotsCursor(idQuery, Optional.of(queryParams));
        return MongoRepository.getOne(mongoLatest).map(d -> this.readFromDBObject((Document)d));
    }

    private List<CdoSnapshot> queryForSnapshots(Bson query, Optional<QueryParams> queryParams) {
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        try (MongoCursor<Document> mongoSnapshots = this.getMongoSnapshotsCursor(query, queryParams);){
            while (mongoSnapshots.hasNext()) {
                Document dbObject = (Document)mongoSnapshots.next();
                snapshots.add(this.readFromDBObject(dbObject));
            }
            ArrayList<CdoSnapshot> arrayList = snapshots;
            return arrayList;
        }
    }

    private static <T> Optional<T> getOne(MongoCursor<T> mongoCursor) {
        try {
            if (!mongoCursor.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<Object> optional = Optional.of(mongoCursor.next());
            return optional;
        }
        finally {
            mongoCursor.close();
        }
    }

    private static Bson prefixQuery(String fieldName, String prefix) {
        return Filters.regex((String)fieldName, (String)("^" + RegexEscape.escape((String)prefix) + ".*"));
    }
}

