/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket;

import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebSocket
extends WebSocketAdapter {
    private boolean tcpNoDelay;
    private Timer connectionLostTimer;
    private TimerTask connectionLostTimerTask;
    private int connectionLostTimeout = 60;

    public int getConnectionLostTimeout() {
        return this.connectionLostTimeout;
    }

    public void setConnectionLostTimeout(int connectionLostTimeout) {
        this.connectionLostTimeout = connectionLostTimeout;
        if (this.connectionLostTimeout <= 0) {
            this.stopConnectionLostTimer();
        } else {
            this.startConnectionLostTimer();
        }
    }

    protected void stopConnectionLostTimer() {
        if (this.connectionLostTimer != null || this.connectionLostTimerTask != null) {
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection lost timer stoped");
            }
            this.cancelConnectionLostTimer();
        }
    }

    protected void startConnectionLostTimer() {
        if (this.connectionLostTimeout <= 0) {
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection lost timer deactivated");
            }
            return;
        }
        if (WebSocketImpl.DEBUG) {
            System.out.println("Connection lost timer started");
        }
        this.cancelConnectionLostTimer();
        this.connectionLostTimer = new Timer();
        this.connectionLostTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Collection<WebSocket> con;
                Collection<WebSocket> collection = con = AbstractWebSocket.this.connections();
                synchronized (collection) {
                    long current = System.currentTimeMillis() - (long)(AbstractWebSocket.this.connectionLostTimeout * 1500);
                    for (WebSocket conn : con) {
                        if (!(conn instanceof WebSocketImpl)) continue;
                        if (((WebSocketImpl)conn).getLastPong() < current) {
                            if (WebSocketImpl.DEBUG) {
                                System.out.println("Closing connection due to no pong received: " + conn.toString());
                            }
                            conn.close(1006);
                            continue;
                        }
                        conn.sendPing();
                    }
                }
            }
        };
        this.connectionLostTimer.scheduleAtFixedRate(this.connectionLostTimerTask, this.connectionLostTimeout * 1000, (long)(this.connectionLostTimeout * 1000));
    }

    protected abstract Collection<WebSocket> connections();

    private void cancelConnectionLostTimer() {
        if (this.connectionLostTimer != null) {
            this.connectionLostTimer.cancel();
            this.connectionLostTimer = null;
        }
        if (this.connectionLostTimerTask != null) {
            this.connectionLostTimerTask.cancel();
            this.connectionLostTimerTask = null;
        }
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }
}

