/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.influxdb.InfluxDB;
import org.influxdb.com.google.guava.base.Preconditions;
import org.influxdb.com.google.guava.collect.Maps;
import org.influxdb.dto.BatchPoints;
import org.influxdb.dto.Point;
import org.influxdb.impl.InfluxDBImpl;

public class BatchProcessor {
    private static final Logger LOG = Logger.getLogger(BatchProcessor.class.getName());
    protected final BlockingQueue<AbstractBatchEntry> queue;
    private final ScheduledExecutorService scheduler;
    private final BiConsumer<Iterable<Point>, Throwable> exceptionHandler;
    final InfluxDBImpl influxDB;
    final int actions;
    private final TimeUnit flushIntervalUnit;
    private final int flushInterval;

    public static Builder builder(InfluxDB influxDB) {
        return new Builder(influxDB);
    }

    BatchProcessor(InfluxDBImpl influxDB, ThreadFactory threadFactory, int actions, TimeUnit flushIntervalUnit, int flushInterval, BiConsumer<Iterable<Point>, Throwable> exceptionHandler) {
        this.influxDB = influxDB;
        this.actions = actions;
        this.flushIntervalUnit = flushIntervalUnit;
        this.flushInterval = flushInterval;
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.exceptionHandler = exceptionHandler;
        this.queue = actions > 1 && actions < Integer.MAX_VALUE ? new LinkedBlockingQueue<AbstractBatchEntry>(actions) : new LinkedBlockingQueue<AbstractBatchEntry>();
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                BatchProcessor.this.write();
            }
        }, this.flushInterval, this.flushInterval, this.flushIntervalUnit);
    }

    void write() {
        ArrayList<Point> currentBatch = null;
        try {
            if (this.queue.isEmpty()) {
                return;
            }
            HashMap<String, BatchPoints> batchKeyToBatchPoints = Maps.newHashMap();
            HashMap udpPortToBatchPoints = Maps.newHashMap();
            ArrayList batchEntries = new ArrayList(this.queue.size());
            this.queue.drainTo(batchEntries);
            currentBatch = new ArrayList<Point>(batchEntries.size());
            for (AbstractBatchEntry abstractBatchEntry : batchEntries) {
                Point point = abstractBatchEntry.getPoint();
                currentBatch.add(point);
                if (abstractBatchEntry instanceof HttpBatchEntry) {
                    HttpBatchEntry httpBatchEntry = (HttpBatchEntry)HttpBatchEntry.class.cast(abstractBatchEntry);
                    String dbName = httpBatchEntry.getDb();
                    String rp = httpBatchEntry.getRp();
                    String batchKey = dbName + "_" + rp;
                    if (!batchKeyToBatchPoints.containsKey(batchKey)) {
                        BatchPoints batchPoints = BatchPoints.database(dbName).retentionPolicy(rp).build();
                        batchKeyToBatchPoints.put(batchKey, batchPoints);
                    }
                    ((BatchPoints)batchKeyToBatchPoints.get(batchKey)).point(point);
                    continue;
                }
                if (!(abstractBatchEntry instanceof UdpBatchEntry)) continue;
                UdpBatchEntry udpBatchEntry = (UdpBatchEntry)UdpBatchEntry.class.cast(abstractBatchEntry);
                int udpPort = udpBatchEntry.getUdpPort();
                if (!udpPortToBatchPoints.containsKey(udpPort)) {
                    ArrayList batchPoints = new ArrayList();
                    udpPortToBatchPoints.put(udpPort, batchPoints);
                }
                ((List)udpPortToBatchPoints.get(udpPort)).add(point.lineProtocol());
            }
            for (BatchPoints batchPoints : batchKeyToBatchPoints.values()) {
                this.influxDB.write(batchPoints);
            }
            for (Map.Entry entry : udpPortToBatchPoints.entrySet()) {
                for (String lineprotocolStr : (List)entry.getValue()) {
                    this.influxDB.write((int)((Integer)entry.getKey()), lineprotocolStr);
                }
            }
        }
        catch (Throwable t) {
            this.exceptionHandler.accept(currentBatch, t);
            LOG.log(Level.SEVERE, "Batch could not be sent. Data will be lost", t);
        }
    }

    void put(AbstractBatchEntry batchEntry) {
        try {
            this.queue.put(batchEntry);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (this.queue.size() >= this.actions) {
            this.scheduler.submit(new Runnable(){

                @Override
                public void run() {
                    BatchProcessor.this.write();
                }
            });
        }
    }

    void flushAndShutdown() {
        this.write();
        this.scheduler.shutdown();
    }

    void flush() {
        this.write();
    }

    static class UdpBatchEntry
    extends AbstractBatchEntry {
        private final int udpPort;

        public UdpBatchEntry(Point point, int udpPort) {
            super(point);
            this.udpPort = udpPort;
        }

        public int getUdpPort() {
            return this.udpPort;
        }
    }

    static class HttpBatchEntry
    extends AbstractBatchEntry {
        private final String db;
        private final String rp;

        public HttpBatchEntry(Point point, String db, String rp) {
            super(point);
            this.db = db;
            this.rp = rp;
        }

        public String getDb() {
            return this.db;
        }

        public String getRp() {
            return this.rp;
        }
    }

    static abstract class AbstractBatchEntry {
        private final Point point;

        public AbstractBatchEntry(Point point) {
            this.point = point;
        }

        public Point getPoint() {
            return this.point;
        }
    }

    public static final class Builder {
        private final InfluxDBImpl influxDB;
        private ThreadFactory threadFactory = Executors.defaultThreadFactory();
        private int actions;
        private TimeUnit flushIntervalUnit;
        private int flushInterval;
        private BiConsumer<Iterable<Point>, Throwable> exceptionHandler = (entries, throwable) -> {};

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder(InfluxDB influxDB) {
            this.influxDB = (InfluxDBImpl)influxDB;
        }

        public Builder actions(int maxActions) {
            this.actions = maxActions;
            return this;
        }

        public Builder interval(int interval, TimeUnit unit) {
            this.flushInterval = interval;
            this.flushIntervalUnit = unit;
            return this;
        }

        public Builder exceptionHandler(BiConsumer<Iterable<Point>, Throwable> handler) {
            this.exceptionHandler = handler;
            return this;
        }

        public BatchProcessor build() {
            Preconditions.checkNotNull(this.influxDB, "influxDB may not be null");
            Preconditions.checkArgument(this.actions > 0, "actions should > 0");
            Preconditions.checkArgument(this.flushInterval > 0, "flushInterval should > 0");
            Preconditions.checkNotNull(this.flushIntervalUnit, "flushIntervalUnit may not be null");
            Preconditions.checkNotNull(this.threadFactory, "threadFactory may not be null");
            Preconditions.checkNotNull(this.exceptionHandler, "exceptionHandler may not be null");
            return new BatchProcessor(this.influxDB, this.threadFactory, this.actions, this.flushIntervalUnit, this.flushInterval, this.exceptionHandler);
        }
    }
}

