/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.querybuilder;

import java.util.Arrays;
import org.influxdb.querybuilder.QueryStringBuilder;
import org.influxdb.querybuilder.SelectSubQueryImpl;
import org.influxdb.querybuilder.Selection;
import org.influxdb.querybuilder.SelectionCoreImpl;
import org.influxdb.querybuilder.SubQuery;
import org.influxdb.querybuilder.WithSubquery;
import org.influxdb.querybuilder.clauses.FromClause;
import org.influxdb.querybuilder.clauses.MultipleFromClause;
import org.influxdb.querybuilder.clauses.OperationClause;
import org.influxdb.querybuilder.clauses.RawFromClause;
import org.influxdb.querybuilder.clauses.SimpleClause;
import org.influxdb.querybuilder.clauses.SimpleFromClause;

public class SelectionSubQueryImpl<T extends WithSubquery>
extends SubQuery<T>
implements Selection,
WithSubquery {
    private final SelectionCoreImpl selectionCore;

    SelectionSubQueryImpl(T selectQuery) {
        this.setParent(selectQuery);
        this.selectionCore = new SelectionCoreImpl();
    }

    @Override
    public SelectionSubQueryImpl<T> distinct() {
        this.selectionCore.distinct();
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> as(String aliasName) {
        this.selectionCore.as(aliasName);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> all() {
        this.selectionCore.all();
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> countAll() {
        this.selectionCore.countAll();
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> column(String name) {
        this.selectionCore.column(name);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> regex(String clause) {
        this.selectionCore.regex(clause);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> function(String name, Object ... parameters) {
        this.selectionCore.function(name, parameters);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> raw(String text) {
        this.selectionCore.raw(text);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> count(Object column) {
        this.selectionCore.count(column);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> max(Object column) {
        this.selectionCore.max(column);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> min(Object column) {
        this.selectionCore.min(column);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> sum(Object column) {
        this.selectionCore.sum(column);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> mean(Object column) {
        this.selectionCore.mean(column);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> op(OperationClause operationClause) {
        this.selectionCore.op(operationClause);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> op(Object arg1, String op, Object arg2) {
        this.selectionCore.op(arg1, op, arg2);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> cop(SimpleClause simpleClause) {
        this.selectionCore.cop(simpleClause);
        return this;
    }

    @Override
    public SelectionSubQueryImpl<T> cop(String column, String op, Object arg2) {
        this.selectionCore.cop(column, op, arg2);
        return this;
    }

    public SelectSubQueryImpl<T> fromRaw(String text) {
        return this.from(new RawFromClause(text));
    }

    public SelectSubQueryImpl<T> from(String[] tables) {
        if (tables == null) {
            throw new IllegalArgumentException("Tables names should be specified");
        }
        return this.from(new MultipleFromClause(Arrays.asList(tables)));
    }

    public SelectSubQueryImpl<T> from(String table) {
        return this.from(new SimpleFromClause(table));
    }

    private SelectSubQueryImpl<T> from(FromClause fromClause) {
        this.selectionCore.clearSelection();
        SelectSubQueryImpl subSelect = new SelectSubQueryImpl(fromClause, this.selectionCore.columns, this.selectionCore.isDistinct);
        subSelect.setParent(this.getParent());
        return subSelect;
    }

    public SelectionSubQueryImpl<SelectSubQueryImpl<T>> fromSubQuery() {
        this.selectionCore.clearSelection();
        SelectSubQueryImpl selectSubQuery = new SelectSubQueryImpl(this.selectionCore.columns, this.selectionCore.isDistinct);
        selectSubQuery.setParent(this.getParent());
        SelectionSubQueryImpl selectionSubQuery = new SelectionSubQueryImpl(selectSubQuery);
        return selectionSubQuery;
    }

    @Override
    public void setSubQuery(QueryStringBuilder query) {
    }

    @Override
    public StringBuilder buildQueryString() {
        return null;
    }

    @Override
    public StringBuilder buildQueryString(StringBuilder stringBuilder) {
        return null;
    }
}

