/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.gson.Gson;
import com.squareup.okhttp.OkHttpClient;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.dto.ContinuousQuery;
import org.influxdb.dto.Database;
import org.influxdb.dto.DatabaseConfiguration;
import org.influxdb.dto.Pong;
import org.influxdb.dto.Serie;
import org.influxdb.dto.Server;
import org.influxdb.dto.Shard;
import org.influxdb.dto.ShardSpace;
import org.influxdb.dto.Shards;
import org.influxdb.dto.User;
import org.influxdb.impl.InfluxDBErrorHandler;
import org.influxdb.impl.InfluxDBService;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;
import retrofit.client.Client;
import retrofit.client.Header;
import retrofit.client.OkClient;
import retrofit.client.Response;

public class InfluxDBImpl
implements InfluxDB {
    private final String username;
    private final String password;
    private final RestAdapter restAdapter;
    private final InfluxDBService influxDBService;
    private final InetAddress host;
    private static final int UDP_MAX_MESSAGE_SIZE = 2048;

    public InfluxDBImpl(String url, String username, String password) {
        this.username = username;
        this.password = password;
        try {
            String hostPart = new URI(url).getHost();
            this.host = InetAddress.getByName(hostPart);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("The given URI is not valid " + e.getMessage());
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("The given URI is not valid " + e.getMessage());
        }
        OkHttpClient okHttpClient = new OkHttpClient();
        this.restAdapter = new RestAdapter.Builder().setEndpoint(url).setErrorHandler((ErrorHandler)new InfluxDBErrorHandler()).setClient((Client)new OkClient(okHttpClient)).build();
        this.influxDBService = (InfluxDBService)this.restAdapter.create(InfluxDBService.class);
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.NONE);
                break;
            }
            case BASIC: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.BASIC);
                break;
            }
            case HEADERS: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.HEADERS);
                break;
            }
            case FULL: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.FULL);
                break;
            }
        }
        return this;
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Pong pong = this.influxDBService.ping();
        pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
        return pong;
    }

    @Override
    public String version() {
        Response response = this.influxDBService.version();
        String version = "unknown";
        List headers = response.getHeaders();
        for (Header header : headers) {
            if (null == header.getName() || !header.getName().equalsIgnoreCase("X-Influxdb-Version")) continue;
            version = header.getValue();
        }
        return version;
    }

    @Override
    public void write(String database, TimeUnit precision, Serie ... series) {
        this.influxDBService.write(database, series, this.username, this.password, InfluxDBImpl.toTimePrecision(precision));
    }

    @Override
    public void writeUdp(int port, Serie ... series) {
        Gson gson = new Gson();
        String data = gson.toJson((Object)series);
        Preconditions.checkArgument((data.length() < 2048 ? 1 : 0) != 0, (Object)("The given data size: " + data.length() + " is larger or equal to the allowed maximum:" + 2048));
        ByteBuffer buf = ByteBuffer.wrap(data.getBytes());
        try {
            DatagramChannel channel = DatagramChannel.open();
            channel.send(buf, new InetSocketAddress(this.host, port));
            buf.clear();
            channel.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    @Override
    public List<Serie> query(String database, String query, TimeUnit precision) {
        return this.influxDBService.query(database, query, this.username, this.password, InfluxDBImpl.toTimePrecision(precision));
    }

    @Override
    public void createDatabase(String name) {
        Database db = new Database(name);
        this.influxDBService.createDatabase(db, this.username, this.password);
    }

    @Override
    public void createDatabase(DatabaseConfiguration config) {
        this.influxDBService.createDatabase(config.getName(), config, this.username, this.password);
    }

    @Override
    public void deleteDatabase(String name) {
        this.influxDBService.deleteDatabase(name, this.username, this.password);
    }

    @Override
    public List<Database> describeDatabases() {
        return this.influxDBService.describeDatabases(this.username, this.password);
    }

    @Override
    public void createClusterAdmin(String name, String adminPassword) {
        User user = new User(name);
        user.setPassword(adminPassword);
        this.influxDBService.createClusterAdmin(user, this.username, this.password);
    }

    @Override
    public void deleteClusterAdmin(String name) {
        this.influxDBService.deleteClusterAdmin(name, this.username, this.password);
    }

    @Override
    public List<User> describeClusterAdmins() {
        return this.influxDBService.describeClusterAdmins(this.username, this.password);
    }

    @Override
    public void updateClusterAdmin(String name, String adminPassword) {
        User user = new User(name);
        user.setPassword(adminPassword);
        this.influxDBService.updateClusterAdmin(user, name, this.username, this.password);
    }

    @Override
    public void createDatabaseUser(String database, String name, String userPassword, String ... permissions) {
        User user = new User(name);
        user.setPassword(userPassword);
        user.setPermissions(permissions);
        this.influxDBService.createDatabaseUser(database, user, this.username, this.password);
    }

    @Override
    public void deleteDatabaseUser(String database, String name) {
        this.influxDBService.deleteDatabaseUser(database, name, this.username, this.password);
    }

    @Override
    public List<User> describeDatabaseUsers(String database) {
        return this.influxDBService.describeDatabaseUsers(database, this.username, this.password);
    }

    @Override
    public void updateDatabaseUser(String database, String name, String newPassword, String ... permissions) {
        User user = new User(name);
        user.setPassword(newPassword);
        user.setPermissions(permissions);
        this.influxDBService.updateDatabaseUser(database, user, name, this.username, this.password);
    }

    @Override
    public void alterDatabasePrivilege(String database, String name, boolean isAdmin, String ... permissions) {
        User user = new User(name);
        user.setAdmin(isAdmin);
        user.setPermissions(permissions);
        this.influxDBService.updateDatabaseUser(database, user, name, this.username, this.password);
    }

    @Override
    public void authenticateDatabaseUser(String database, String user, String userPassword) {
        this.influxDBService.authenticateDatabaseUser(database, user, userPassword);
    }

    @Override
    public List<ContinuousQuery> describeContinuousQueries(String database) {
        return this.influxDBService.getContinuousQueries(database, this.username, this.password);
    }

    @Override
    public void deleteContinuousQuery(String database, int id) {
        this.influxDBService.deleteContinuousQuery(database, id, this.username, this.password);
    }

    @Override
    public void deleteSeries(String database, String serieName) {
        this.influxDBService.deleteSeries(database, serieName, this.username, this.password);
    }

    @Override
    public void forceRaftCompaction() {
        this.influxDBService.forceRaftCompaction(this.username, this.password);
    }

    @Override
    public List<String> interfaces() {
        return this.influxDBService.interfaces(this.username, this.password);
    }

    @Override
    public Boolean sync() {
        return this.influxDBService.sync(this.username, this.password);
    }

    @Override
    public List<Server> listServers() {
        return this.influxDBService.listServers(this.username, this.password);
    }

    @Override
    public void removeServers(int id) {
        this.influxDBService.removeServers(id, this.username, this.password);
    }

    @Override
    public void createShard(Shard shard) {
        this.influxDBService.createShard(this.username, this.password, shard);
    }

    @Override
    public Shards getShards() {
        return this.influxDBService.getShards(this.username, this.password);
    }

    @Override
    public void dropShard(Shard shard) {
        this.influxDBService.dropShard(shard.getId(), this.username, this.password, shard.getShards().get(0));
    }

    @Override
    public List<ShardSpace> getShardSpaces() {
        return this.influxDBService.getShardSpaces(this.username, this.password);
    }

    @Override
    public void dropShardSpace(String database, String name) {
        this.influxDBService.dropShardSpace(database, name, this.username, this.password);
    }

    @Override
    public void createShardSpace(String database, ShardSpace shardSpace) {
        this.influxDBService.createShardSpace(database, this.username, this.password, shardSpace);
    }

    private static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case MICROSECONDS: {
                return "u";
            }
        }
        throw new IllegalArgumentException("time precision must be " + (Object)((Object)TimeUnit.SECONDS) + ", " + (Object)((Object)TimeUnit.MILLISECONDS) + " or " + (Object)((Object)TimeUnit.MICROSECONDS));
    }
}

