/*
 * Decompiled with CFR 0.152.
 */
package org.influxdb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.influxdb.InfluxDB;
import org.influxdb.dto.ContinuousQuery;
import org.influxdb.dto.Database;
import org.influxdb.dto.Pong;
import org.influxdb.dto.ScheduledDelete;
import org.influxdb.dto.Serie;
import org.influxdb.dto.User;
import org.influxdb.impl.InfluxDBErrorHandler;
import org.influxdb.impl.InfluxDBService;
import retrofit.ErrorHandler;
import retrofit.RestAdapter;

public class InfluxDBImpl
implements InfluxDB {
    private final String username;
    private final String password;
    private final RestAdapter restAdapter;
    private final InfluxDBService influxDBService;

    public InfluxDBImpl(String url, String username, String password) {
        this.username = username;
        this.password = password;
        this.restAdapter = new RestAdapter.Builder().setEndpoint(url).setErrorHandler((ErrorHandler)new InfluxDBErrorHandler()).build();
        this.influxDBService = (InfluxDBService)this.restAdapter.create(InfluxDBService.class);
    }

    @Override
    public InfluxDB setLogLevel(InfluxDB.LogLevel logLevel) {
        switch (logLevel) {
            case NONE: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.NONE);
                break;
            }
            case BASIC: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.BASIC);
                break;
            }
            case HEADERS: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.HEADERS);
                break;
            }
            case FULL: {
                this.restAdapter.setLogLevel(RestAdapter.LogLevel.FULL);
                break;
            }
        }
        return this;
    }

    @Override
    public Pong ping() {
        Stopwatch watch = Stopwatch.createStarted();
        Pong pong = this.influxDBService.ping();
        pong.setResponseTime(watch.elapsed(TimeUnit.MILLISECONDS));
        return pong;
    }

    @Override
    public void write(String database, TimeUnit precision, Serie ... series) {
        this.influxDBService.write(database, series, this.username, this.password, InfluxDBImpl.toTimePrecision(precision));
    }

    @Override
    public List<Serie> Query(String database, String query, TimeUnit precision) {
        return this.influxDBService.query(database, query, this.username, this.password, InfluxDBImpl.toTimePrecision(precision));
    }

    @Override
    public void createDatabase(String name, int replicationFactor) {
        Preconditions.checkArgument(replicationFactor >= 1, "Replicationfactor must be greater or equal to 1.");
        Database db = new Database(name, replicationFactor);
        this.influxDBService.createDatabase(db, this.username, this.password);
    }

    @Override
    public void deleteDatabase(String name) {
        this.influxDBService.deleteDatabase(name, this.username, this.password);
    }

    @Override
    public List<Database> describeDatabases() {
        return this.influxDBService.describeDatabases(this.username, this.password);
    }

    @Override
    public void createClusterAdmin(String name, String adminPassword) {
        User user = new User(name);
        user.setPassword(adminPassword);
        this.influxDBService.createClusterAdmin(user, this.username, this.password);
    }

    @Override
    public void deleteClusterAdmin(String name) {
        this.influxDBService.deleteClusterAdmin(name, this.username, this.password);
    }

    @Override
    public List<User> describeClusterAdmins() {
        return this.influxDBService.describeClusterAdmins(this.username, this.password);
    }

    @Override
    public void updateClusterAdmin(String name, String adminPassword) {
        User user = new User(name);
        user.setPassword(adminPassword);
        this.influxDBService.updateClusterAdmin(user, name, this.username, this.password);
    }

    @Override
    public void createDatabaseUser(String database, String name, String userPassword, String ... permissions) {
        User user = new User(name);
        user.setPassword(userPassword);
        user.setPermissions(permissions);
        this.influxDBService.createDatabaseUser(database, user, this.username, this.password);
    }

    @Override
    public void deleteDatabaseUser(String database, String name) {
        this.influxDBService.deleteDatabaseUser(database, name, this.username, this.password);
    }

    @Override
    public List<User> describeDatabaseUsers(String database) {
        return this.influxDBService.describeDatabaseUsers(database, this.username, this.password);
    }

    @Override
    public void updateDatabaseUser(String database, String name, String newPassword, String ... permissions) {
        User user = new User(name);
        user.setPassword(newPassword);
        user.setPermissions(permissions);
        this.influxDBService.updateDatabaseUser(database, user, name, this.username, this.password);
    }

    @Override
    public void alterDatabasePrivilege(String database, String name, boolean isAdmin, String ... permissions) {
        User user = new User(name);
        user.setAdmin(isAdmin);
        user.setPermissions(permissions);
        this.influxDBService.updateDatabaseUser(database, user, name, this.username, this.password);
    }

    @Override
    public void authenticateDatabaseUser(String database, String user, String userPassword) {
        this.influxDBService.authenticateDatabaseUser(database, user, userPassword);
    }

    @Override
    public List<ContinuousQuery> describeContinuousQueries(String database) {
        return this.influxDBService.getContinuousQueries(database, this.username, this.password);
    }

    @Override
    public void deleteContinuousQuery(String database, int id) {
        this.influxDBService.deleteContinuousQuery(database, id, this.username, this.password);
    }

    @Override
    public void deletePoints(String database, String serieName) {
        this.influxDBService.deletePoints(database, serieName, this.username, this.password);
    }

    @Override
    public void createScheduledDelete(String database, ScheduledDelete delete) {
        throw new IllegalArgumentException("This is not implemented in InfluxDB, please see: https://github.com/influxdb/influxdb/issues/98");
    }

    @Override
    public List<ScheduledDelete> describeScheduledDeletes(String database) {
        throw new IllegalArgumentException("This is not implemented in InfluxDB, please see: https://github.com/influxdb/influxdb/issues/98");
    }

    @Override
    public void deleteScheduledDelete(String database, int id) {
        throw new IllegalArgumentException("This is not implemented in InfluxDB, please see: https://github.com/influxdb/influxdb/issues/98");
    }

    private static String toTimePrecision(TimeUnit t) {
        switch (t) {
            case SECONDS: {
                return "s";
            }
            case MILLISECONDS: {
                return "m";
            }
            case MICROSECONDS: {
                return "u";
            }
        }
        throw new IllegalArgumentException("time precision should be SECONDS or MILLISECONDS or MICROSECONDS");
    }
}

