/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;

public abstract class Charset
implements Comparable<Charset> {
    private static final Charset UTF_8 = new Charset("UTF-8"){};
    private static final SortedMap<String, Charset> AVAILABLE_CHARSETS = new TreeMap<String, Charset>();
    private final String name;

    public static SortedMap<String, Charset> availableCharsets() {
        return Collections.unmodifiableSortedMap(AVAILABLE_CHARSETS);
    }

    public static Charset forName(String charsetName) {
        if (charsetName == null) {
            throw new IllegalArgumentException("Null charset name");
        }
        int length = charsetName.length();
        if (length == 0) {
            throw new IllegalCharsetNameException(charsetName);
        }
        for (int i = 0; i < length; ++i) {
            char c = charsetName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-' && i != 0 || c == ':' && i != 0 || c == '_' && i != 0 || c == '.' && i != 0) continue;
            throw new IllegalCharsetNameException(charsetName);
        }
        Charset charset = (Charset)AVAILABLE_CHARSETS.get(charsetName.toUpperCase());
        if (charset != null) {
            return charset;
        }
        throw new UnsupportedCharsetException(charsetName);
    }

    private Charset(String name) {
        this.name = name;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public final int compareTo(Charset that) {
        return this.name.compareToIgnoreCase(that.name);
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Charset) {
            Charset that = (Charset)o;
            return this.name.equals(that.name);
        }
        return false;
    }

    public final String toString() {
        return this.name;
    }

    static {
        AVAILABLE_CHARSETS.put(UTF_8.name(), UTF_8);
    }
}

