/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

final class ServiceLoaderFileGenerator {
    private static final String META_INF_SERVICES = "META-INF/services/";
    private final String resourceFile;
    private final Set<String> providers = new HashSet<String>();
    private final List<Element> originatingElements = new ArrayList<Element>();

    ServiceLoaderFileGenerator(Class<?> serviceInterface) {
        this.resourceFile = META_INF_SERVICES + serviceInterface.getName();
    }

    void addProvider(String providerClass, Element originatingElement) {
        this.providers.add(providerClass);
        this.originatingElements.add(originatingElement);
    }

    void writeServiceFile(Filer filer) throws IOException {
        if (!this.providers.isEmpty()) {
            LinkedHashSet<String> serviceProviders;
            FileObject fileObject;
            try {
                fileObject = filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.resourceFile);
                serviceProviders = ServiceLoaderFileGenerator.readServiceFile(fileObject.openInputStream());
            }
            catch (IOException e) {
                serviceProviders = new LinkedHashSet<String>();
            }
            if (serviceProviders.addAll(this.providers)) {
                fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.resourceFile, this.originatingElements.toArray(new Element[0]));
                ServiceLoaderFileGenerator.writeServiceFile(serviceProviders, fileObject.openOutputStream());
            }
        }
    }

    private static Set<String> readServiceFile(InputStream in) throws IOException {
        LinkedHashSet<String> services = new LinkedHashSet<String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                int commentPos = line.indexOf(35);
                if (commentPos != -1) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).isEmpty()) continue;
                services.add(line);
            }
        }
        return services;
    }

    private static void writeServiceFile(Collection<String> services, OutputStream out) throws IOException {
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
            for (String service : services) {
                w.write(service);
                w.newLine();
            }
            w.flush();
        }
    }
}

