/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;

final class GeneratedFilesWriter {
    private final Map<String, GeneratedFile> generatedFiles = new LinkedHashMap<String, GeneratedFile>();
    private final Filer filer;
    private boolean isEnabled = true;

    GeneratedFilesWriter(Filer filer) {
        this.filer = filer;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void addMarshallerSourceFile(String className, String source, Element originatingElement) throws IOException {
        this.addGeneratedFile(className, new SourceFile(this.isEnabled, className, source, originatingElement));
    }

    public void addInitializerSourceFile(String className, String source, Element[] originatingElements) throws IOException {
        this.addGeneratedFile(className, new SourceFile(this.isEnabled, className, source, originatingElements));
    }

    public void addSchemaResourceFile(String fileName, String source, Element[] originatingElements) throws IOException {
        this.addGeneratedFile(fileName, new ResourceFile(this.isEnabled, fileName, source, originatingElements));
    }

    private void addGeneratedFile(String fqn, GeneratedFile file) throws IOException {
        boolean doWrite = true;
        GeneratedFile existingFile = this.generatedFiles.get(fqn);
        if (existingFile != null) {
            if (!file.getSource().equals(existingFile.getSource())) {
                throw new IllegalStateException("File " + fqn + " was generated twice with different contents.");
            }
            boolean bl = doWrite = !existingFile.isEnabled() && this.isEnabled;
        }
        if (doWrite) {
            this.generatedFiles.put(fqn, file);
            if (this.isEnabled) {
                file.write(this.filer);
            }
        }
    }

    private static boolean checkResourceFileUpToDate(Filer filer, String fileName, String contents) {
        boolean bl;
        block8: {
            FileObject resourceFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", fileName);
            InputStream is = resourceFile.openInputStream();
            try {
                String existing = GeneratedFilesWriter.readUtf8String(is);
                bl = contents.equals(existing);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkSourceFileUpToDate(Filer filer, String className, String contents) {
        long classTimestamp;
        long sourceTimestamp;
        String fileName = className.replace('.', '/');
        try {
            FileObject javaFile = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", fileName + ".java");
            try (InputStream is = javaFile.openInputStream();){
                String existing = GeneratedFilesWriter.readUtf8String(is);
                if (!contents.equals(existing)) {
                    boolean bl = false;
                    return bl;
                }
            }
            sourceTimestamp = javaFile.getLastModified();
        }
        catch (IOException e) {
            return false;
        }
        try {
            FileObject classFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", fileName + ".class");
            classTimestamp = classFile.getLastModified();
        }
        catch (IOException e) {
            return false;
        }
        if (sourceTimestamp > classTimestamp) return false;
        return true;
    }

    private static String readUtf8String(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            bytes.write(buf, 0, len);
        }
        return bytes.toString(StandardCharsets.UTF_8.name());
    }

    private static final class SourceFile
    implements GeneratedFile {
        private final boolean isEnabled;
        private final String className;
        private final String source;
        private final Element[] originatingElements;

        SourceFile(boolean isEnabled, String className, String source, Element ... originatingElements) {
            this.isEnabled = isEnabled;
            this.className = className;
            this.source = source;
            this.originatingElements = originatingElements;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public void write(Filer filer) throws IOException {
            JavaFileObject file;
            if (GeneratedFilesWriter.checkSourceFileUpToDate(filer, this.className, this.source)) {
                return;
            }
            try {
                file = filer.createSourceFile(this.className, this.originatingElements);
            }
            catch (FilerException fe) {
                throw new AnnotationProcessingException(fe, this.originatingElements[0], "%s", fe.getMessage());
            }
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.print(this.source);
            }
        }
    }

    static interface GeneratedFile {
        public boolean isEnabled();

        public String getSource();

        public void write(Filer var1) throws IOException;
    }

    private static final class ResourceFile
    implements GeneratedFile {
        private final boolean isEnabled;
        private final String fileName;
        private final String source;
        private final Element[] originatingElements;

        ResourceFile(boolean isEnabled, String fileName, String source, Element ... originatingElements) {
            this.isEnabled = isEnabled;
            this.fileName = fileName.startsWith("/") ? fileName.substring(1) : fileName;
            this.source = source;
            this.originatingElements = originatingElements;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public void write(Filer filer) throws IOException {
            FileObject file;
            if (GeneratedFilesWriter.checkResourceFileUpToDate(filer, this.fileName, this.source)) {
                return;
            }
            try {
                file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.fileName, this.originatingElements);
            }
            catch (FilerException e) {
                throw new AnnotationProcessingException(e, this.originatingElements[0], "Failed to create resource file \"%s\". Name could be invalid or the file already exists?", this.fileName);
            }
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.print(this.source);
            }
        }
    }
}

