/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.infinispan.protostream.annotations.impl.processor.AnnotationProcessingException;

final class GeneratedFilesWriter {
    private final Map<String, GeneratedFile> generatedFiles = new LinkedHashMap<String, GeneratedFile>();
    private final Filer filer;
    private boolean isEnabled = true;

    GeneratedFilesWriter(Filer filer) {
        this.filer = filer;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void addMarshallerSourceFile(String className, String source, Element originatingElement) throws IOException {
        this.addGeneratedFile(className, new SourceFile(this.isEnabled, className, source, originatingElement));
    }

    public void addInitializerSourceFile(String className, String source, Element[] originatingElements) throws IOException {
        this.addGeneratedFile(className, new SourceFile(this.isEnabled, className, source, originatingElements));
    }

    public void addSchemaResourceFile(String pkg, String relativeName, String source, Element[] originatingElements) throws IOException {
        String fqn = pkg.isEmpty() ? relativeName : pkg + '/' + relativeName;
        this.addGeneratedFile(fqn, new ResourceFile(this.isEnabled, pkg, relativeName, source, originatingElements));
    }

    private void addGeneratedFile(String fqn, GeneratedFile file) throws IOException {
        boolean doWrite = true;
        GeneratedFile existingFile = this.generatedFiles.get(fqn);
        if (existingFile != null) {
            if (!file.getSource().equals(existingFile.getSource())) {
                throw new IllegalStateException("File " + fqn + " was generated twice with different contents.");
            }
            boolean bl = doWrite = !existingFile.isEnabled() && this.isEnabled;
        }
        if (doWrite) {
            this.generatedFiles.put(fqn, file);
            if (this.isEnabled) {
                file.write(this.filer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getResourceFileContents(Filer filer, String pkg, String relativeName) throws IOException {
        InputStream is;
        try {
            is = filer.getResource(StandardLocation.CLASS_OUTPUT, pkg, relativeName).openInputStream();
        }
        catch (IOException e) {
            return null;
        }
        try {
            String string = GeneratedFilesWriter.readUtf8String(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSourceFileContents(Filer filer, String className) throws IOException {
        InputStream is;
        try {
            is = filer.getResource(StandardLocation.SOURCE_OUTPUT, "", className.replace('.', '/') + ".java").openInputStream();
        }
        catch (IOException e) {
            return null;
        }
        try {
            String string = GeneratedFilesWriter.readUtf8String(is);
            return string;
        }
        finally {
            is.close();
        }
    }

    private static String readUtf8String(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) != -1) {
            bytes.write(buf, 0, len);
        }
        return bytes.toString(StandardCharsets.UTF_8.name());
    }

    private static final class ResourceFile
    implements GeneratedFile {
        private final boolean isEnabled;
        private final String pkg;
        private final String relativeName;
        private final String source;
        private final Element[] originatingElements;

        ResourceFile(boolean isEnabled, String pkg, String relativeName, String source, Element ... originatingElements) {
            this.isEnabled = isEnabled;
            this.pkg = pkg;
            this.relativeName = relativeName;
            this.source = source;
            this.originatingElements = originatingElements;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public void write(Filer filer) throws IOException {
            FileObject file;
            if (this.source.equals(GeneratedFilesWriter.getResourceFileContents(filer, this.pkg, this.relativeName))) {
                return;
            }
            try {
                file = filer.createResource(StandardLocation.CLASS_OUTPUT, this.pkg, this.relativeName, this.originatingElements);
            }
            catch (FilerException e) {
                throw new AnnotationProcessingException(e, this.originatingElements[0], "Package %s already contains a resource file named %s", this.pkg, this.relativeName);
            }
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.print(this.source);
            }
        }
    }

    private static final class SourceFile
    implements GeneratedFile {
        private final boolean isEnabled;
        private final String className;
        private final String source;
        private final Element[] originatingElements;

        SourceFile(boolean isEnabled, String className, String source, Element ... originatingElements) {
            this.isEnabled = isEnabled;
            this.className = className;
            this.source = source;
            this.originatingElements = originatingElements;
        }

        @Override
        public boolean isEnabled() {
            return this.isEnabled;
        }

        @Override
        public String getSource() {
            return this.source;
        }

        @Override
        public void write(Filer filer) throws IOException {
            JavaFileObject file;
            if (this.source.equals(GeneratedFilesWriter.getSourceFileContents(filer, this.className))) {
                return;
            }
            try {
                file = filer.createSourceFile(this.className, this.originatingElements);
            }
            catch (FilerException fe) {
                throw new AnnotationProcessingException(fe, this.originatingElements[0], "%s", fe.getMessage());
            }
            try (PrintWriter out = new PrintWriter(file.openWriter());){
                out.print(this.source);
            }
        }
    }

    static interface GeneratedFile {
        public boolean isEnabled();

        public String getSource();

        public void write(Filer var1) throws IOException;
    }
}

