/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Modifier;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.FilerException;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.infinispan.protostream.ProtobufUtil;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.infinispan.protostream.annotations.AutoProtoSchemaBuilder;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoMessage;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.processor.CompileTimeProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.processor.ServiceLoaderFileGenerator;
import org.infinispan.protostream.annotations.impl.processor.SourceFileWriter;
import org.infinispan.protostream.annotations.impl.processor.types.HasModelElement;
import org.infinispan.protostream.annotations.impl.processor.types.MirrorClassFactory;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XMethod;

@SupportedOptions(value={"debug"})
@SupportedAnnotationTypes(value={"org.infinispan.protostream.annotations.AutoProtoSchemaBuilder"})
public final class AutoProtoSchemaBuilderAnnotationProcessor
extends AbstractProcessor {
    public static final String DEBUG_OPTION = "debug";
    public static final String AUTOPROTOSCHEMABUILDER_ANNOTATION_NAME = "org.infinispan.protostream.annotations.AutoProtoSchemaBuilder";
    private ServiceLoaderFileGenerator serviceLoaderFileGenerator = new ServiceLoaderFileGenerator(SerializationContextInitializer.class);
    private boolean isDebugEnabled;
    private Types types;
    private Elements elements;
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.isDebugEnabled = processingEnv.getOptions().containsKey(DEBUG_OPTION);
        this.types = processingEnv.getTypeUtils();
        this.elements = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void reportError(AnnotationProcessingException ex) {
        String formatted = String.format(ex.message, ex.msgParams);
        if (ex.location != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted, ex.location);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private void reportError(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.ERROR, formatted);
        }
    }

    private void reportWarning(Element e, String message, Object ... msgParams) {
        String formatted = String.format(message, msgParams);
        if (e != null) {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted, e);
        } else {
            this.messager.printMessage(Diagnostic.Kind.WARNING, formatted);
        }
    }

    private void logDebug(String message, Object ... msgParams) {
        if (this.isDebugEnabled) {
            String formatted = String.format(message, msgParams);
            this.messager.printMessage(Diagnostic.Kind.NOTE, formatted);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            boolean claimed;
            TypeElement annotationTypeElement = null;
            boolean bl = claimed = annotations.size() == 1 && (annotationTypeElement = annotations.iterator().next()).getQualifiedName().contentEquals(AUTOPROTOSCHEMABUILDER_ANNOTATION_NAME);
            if (claimed) {
                for (Element element : roundEnv.getElementsAnnotatedWith(annotationTypeElement)) {
                    if (this.isGeneratedByMe(element)) continue;
                    AutoProtoSchemaBuilder builderAnnotation = element.getAnnotation(AutoProtoSchemaBuilder.class);
                    SerializationContext serCtx = ProtobufUtil.newSerializationContext();
                    try {
                        this.processElement(true, roundEnv, serCtx, element, builderAnnotation);
                    }
                    catch (ProtoSchemaBuilderException e) {
                        throw new AnnotationProcessingException(e, element, "%s", e.getMessage());
                    }
                }
            }
            if (roundEnv.processingOver()) {
                this.serviceLoaderFileGenerator.generateResources(this.filer);
            }
        }
        catch (AnnotationProcessingException e) {
            if (this.isDebugEnabled) {
                this.logDebug("@AutoProtoSchemaBuilder processor threw an exception: %s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
            }
            this.reportError(e);
        }
        catch (Exception e) {
            this.reportError(null, "@AutoProtoSchemaBuilder processor threw a fatal exception: %s", AutoProtoSchemaBuilderAnnotationProcessor.getStackTraceAsString(e));
        }
        return true;
    }

    private boolean isGeneratedByMe(Element annotatedElement) {
        Generated generated = annotatedElement.getAnnotation(Generated.class);
        if (generated != null) {
            for (String generator : generated.value()) {
                if (!generator.equals(AutoProtoSchemaBuilderAnnotationProcessor.class.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    /*
     * WARNING - void declaration
     */
    private Collection<? extends TypeMirror> getClassesToProcess(RoundEnvironment roundEnv, Element builderElement, AutoProtoSchemaBuilder builderAnnotation) {
        List<Object> specifiedClasses = Collections.emptyList();
        try {
            builderAnnotation.classes();
        }
        catch (MirroredTypesException mte) {
            specifiedClasses = mte.getTypeMirrors();
        }
        TreeMap<String, TypeMirror> classes = new TreeMap<String, TypeMirror>();
        if (specifiedClasses.isEmpty()) {
            TypeElement typeElement;
            Element enclosingElement;
            void var9_16;
            HashSet<String> packages = builderAnnotation.packages().length == 0 ? null : new HashSet<String>(builderAnnotation.packages().length);
            String[] stringArray = builderAnnotation.packages();
            int n = stringArray.length;
            boolean bl = false;
            while (var9_16 < n) {
                String p = stringArray[var9_16];
                if (!SourceVersion.isName(p)) {
                    throw new AnnotationProcessingException(builderElement, "@AutoProtoSchemaBuilder.packages contains and invalid package name : \"%s\"", p);
                }
                packages.add(p);
                ++var9_16;
            }
            PackageElement packageElement = this.elements.getPackageOf(builderElement);
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoField.class)) {
                enclosingElement = element.getEnclosingElement();
                if (enclosingElement.getKind() != ElementKind.CLASS && enclosingElement.getKind() != ElementKind.INTERFACE) continue;
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, packages, packageElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnumValue.class)) {
                enclosingElement = element.getEnclosingElement();
                if (element.getKind() != ElementKind.ENUM_CONSTANT || enclosingElement.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoEnumValue can only be applied to enum constants.", new Object[0]);
                }
                TypeElement typeElement2 = (TypeElement)enclosingElement;
                this.filterByPackage(classes, typeElement2, packages, packageElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoEnum.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoEnum can only be applied to enums.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, packages, packageElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoMessage.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE) {
                    throw new AnnotationProcessingException(element, "@ProtoMessage can only be applied to classes and interfaces.", new Object[0]);
                }
                typeElement = (TypeElement)element;
                this.filterByPackage(classes, typeElement, packages, packageElement);
            }
            for (Element element : roundEnv.getElementsAnnotatedWith(ProtoName.class)) {
                if (element.getKind() != ElementKind.CLASS && element.getKind() != ElementKind.INTERFACE && element.getKind() != ElementKind.ENUM) {
                    throw new AnnotationProcessingException(element, "@ProtoName can only be applied to classes, interfaces and enums.", new Object[0]);
                }
                typeElement = (TypeElement)element.getEnclosingElement();
                this.filterByPackage(classes, typeElement, packages, packageElement);
            }
        } else {
            if (builderAnnotation.packages().length != 0) {
                throw new AnnotationProcessingException(builderElement, "@AutoProtoSchemaBuilder.packages cannot be specified unless @AutoProtoSchemaBuilder.classes is empty.", new Object[0]);
            }
            for (TypeMirror typeMirror : specifiedClasses) {
                TypeElement typeElement = (TypeElement)((DeclaredType)typeMirror).asElement();
                String string = typeElement.getQualifiedName().toString();
                classes.putIfAbsent(string, typeMirror);
            }
        }
        return classes.values();
    }

    private void filterByPackage(Map<String, TypeMirror> collectedClasses, TypeElement typeElement, Set<String> packages, PackageElement packageOfInitializer) {
        String packageName;
        if (typeElement.getKind() == ElementKind.INTERFACE || typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.ABSTRACT)) {
            return;
        }
        PackageElement packageOfElement = this.elements.getPackageOf(typeElement);
        if (packageOfElement.isUnnamed() && !packageOfInitializer.isUnnamed()) {
            return;
        }
        if (!typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.PUBLIC) && !packageOfElement.equals(packageOfInitializer)) {
            return;
        }
        String fqn = typeElement.getQualifiedName().toString();
        if (packages != null && !this.isPackageIncluded(packages, packageName = packageOfElement.getQualifiedName().toString())) {
            return;
        }
        collectedClasses.putIfAbsent(fqn, typeElement.asType());
    }

    private boolean isPackageIncluded(Set<String> packages, String packageName) {
        String p = packageName;
        while (true) {
            if (packages.contains(p)) {
                return true;
            }
            int pos = p.lastIndexOf(46);
            if (pos == -1) break;
            p = p.substring(0, pos);
        }
        return false;
    }

    private Map<XClass, String> processElement(boolean generateFiles, RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, AutoProtoSchemaBuilder annotation) throws IOException {
        if (annotatedElement.getKind() != ElementKind.PACKAGE && annotatedElement.getKind() != ElementKind.INTERFACE && annotatedElement.getKind() != ElementKind.CLASS) {
            throw new AnnotationProcessingException(annotatedElement, "@AutoProtoSchemaBuilder annotation can only be applied to classes, interfaces and packages.", new Object[0]);
        }
        Collection<? extends TypeMirror> protoClasses = this.getClassesToProcess(roundEnv, annotatedElement, annotation);
        if (protoClasses.isEmpty()) {
            this.reportWarning(annotatedElement, "No ProtoStream annotated classes found matching the criteria. Please review the 'classes' / 'packages' attribute of the @AutoProtoSchemaBuilder annotation.", new Object[0]);
        }
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            return this.processPackage(generateFiles, roundEnv, serCtx, (PackageElement)annotatedElement, annotation, protoClasses);
        }
        return this.processClass(generateFiles, roundEnv, serCtx, (TypeElement)annotatedElement, annotation, protoClasses);
    }

    private Map<XClass, String> processPackage(boolean generateFiles, RoundEnvironment roundEnv, SerializationContext serCtx, PackageElement packageElement, AutoProtoSchemaBuilder builderAnnotation, Collection<? extends TypeMirror> classes) throws IOException {
        String initializerClassName = builderAnnotation.className();
        if (initializerClassName.isEmpty()) {
            throw new AnnotationProcessingException(packageElement, "@AutoProtoSchemaBuilder.className is required when annotating a package.", new Object[0]);
        }
        if (!SourceVersion.isIdentifier(initializerClassName) || SourceVersion.isKeyword(initializerClassName)) {
            throw new AnnotationProcessingException(packageElement, "@AutoProtoSchemaBuilder.className annotation attribute must be a valid Java identifier and must not be fully qualified.", new Object[0]);
        }
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String protobufPackageName = builderAnnotation.schemaPackageName().isEmpty() ? null : builderAnnotation.schemaPackageName();
        String protobufFileName = builderAnnotation.schemaFileName();
        if (protobufFileName.isEmpty()) {
            protobufFileName = packageElement.getSimpleName().toString() + ".proto";
        }
        String protobufFilePath = builderAnnotation.schemaFilePath().isEmpty() ? protobufFileName : builderAnnotation.schemaFilePath().replace('.', '/') + '/' + protobufFileName;
        InitializerDependencies dependencies = this.processDependencies(roundEnv, serCtx, packageElement, builderAnnotation);
        MirrorClassFactory typeFactory = new MirrorClassFactory(this.processingEnv);
        Set xclasses = classes.stream().map(typeFactory::fromTypeMirror).collect(Collectors.toCollection(LinkedHashSet::new));
        HashMap<XClass, String> result = new HashMap<XClass, String>(dependencies.depClasses);
        for (XClass x : xclasses) {
            result.put(x, protobufFilePath);
        }
        SourceFileWriter sourceFileWriter = new SourceFileWriter();
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(typeFactory, sourceFileWriter, serCtx, protobufFilePath, protobufPackageName, dependencies.depClasses, xclasses, builderAnnotation.autoImportClasses());
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        if (generateFiles) {
            sourceFileWriter.writeFiles(this.processingEnv.getFiler());
            this.generateSerializationContextInitializer(packageElement, packageElement.getQualifiedName().toString(), builderAnnotation, dependencies.initializerClassNames, classes, initializerPackageName, initializerClassName, protobufFileName, protobufPackageName, schemaSrc, sourceFileWriter.getGeneratedMarshallerClasses());
        }
        return result;
    }

    private Map<XClass, String> processClass(boolean generateFiles, RoundEnvironment roundEnv, SerializationContext serCtx, TypeElement typeElement, AutoProtoSchemaBuilder builderAnnotation, Collection<? extends TypeMirror> classes) throws IOException {
        if (typeElement.getNestingKind() == NestingKind.LOCAL || typeElement.getNestingKind() == NestingKind.ANONYMOUS) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @AutoProtoSchemaBuilder must not be local or anonymous.", new Object[0]);
        }
        if (typeElement.getNestingKind() == NestingKind.MEMBER && !typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.STATIC)) {
            throw new AnnotationProcessingException(typeElement, "Nested classes or interfaces annotated with @AutoProtoSchemaBuilder must be static.", new Object[0]);
        }
        if (typeElement.getModifiers().contains((Object)javax.lang.model.element.Modifier.FINAL)) {
            throw new AnnotationProcessingException(typeElement, "Classes annotated with @AutoProtoSchemaBuilder must not be final.", new Object[0]);
        }
        if (!(builderAnnotation.className().isEmpty() || SourceVersion.isIdentifier(builderAnnotation.className()) && !SourceVersion.isKeyword(builderAnnotation.className()))) {
            throw new AnnotationProcessingException(typeElement, "@AutoProtoSchemaBuilder.className annotation attribute must be a valid Java identifier and must not be fully qualified.", new Object[0]);
        }
        TypeMirror serializationContextInitializerTypeMirror = this.elements.getTypeElement(SerializationContextInitializer.class.getName()).asType();
        if (!this.types.isSubtype(typeElement.asType(), serializationContextInitializerTypeMirror)) {
            throw new AnnotationProcessingException(typeElement, "Classes or interfaces annotated with @AutoProtoSchemaBuilder must implement/extend %s", SerializationContextInitializer.class.getName());
        }
        PackageElement packageElement = this.elements.getPackageOf(typeElement);
        String initializerPackageName = packageElement.isUnnamed() ? null : packageElement.getQualifiedName().toString();
        String initializerClassName = this.getInitializerClassName(typeElement, builderAnnotation);
        String protobufPackageName = builderAnnotation.schemaPackageName().isEmpty() ? null : builderAnnotation.schemaPackageName();
        String protobufFileName = builderAnnotation.schemaFileName();
        if (protobufFileName.isEmpty()) {
            protobufFileName = typeElement.getSimpleName() + ".proto";
        }
        String protobufFilePath = builderAnnotation.schemaFilePath().isEmpty() ? protobufFileName : builderAnnotation.schemaFilePath().replace('.', '/') + '/' + protobufFileName;
        InitializerDependencies dependencies = this.processDependencies(roundEnv, serCtx, typeElement, builderAnnotation);
        MirrorClassFactory typeFactory = new MirrorClassFactory(this.processingEnv);
        this.warnOverrideExistingMethods(typeElement, typeFactory);
        Set xclasses = classes.stream().map(typeFactory::fromTypeMirror).collect(Collectors.toCollection(LinkedHashSet::new));
        HashMap<XClass, String> result = new HashMap<XClass, String>(dependencies.depClasses);
        for (XClass x : xclasses) {
            result.put(x, protobufFilePath);
        }
        SourceFileWriter sourceFileWriter = new SourceFileWriter();
        CompileTimeProtoSchemaGenerator protoSchemaGenerator = new CompileTimeProtoSchemaGenerator(typeFactory, sourceFileWriter, serCtx, protobufFilePath, protobufPackageName, dependencies.depClasses, xclasses, builderAnnotation.autoImportClasses());
        String schemaSrc = protoSchemaGenerator.generateAndRegister();
        if (generateFiles) {
            sourceFileWriter.writeFiles(this.processingEnv.getFiler());
            this.generateSerializationContextInitializer(typeElement, typeElement.getQualifiedName().toString(), builderAnnotation, dependencies.initializerClassNames, classes, initializerPackageName, initializerClassName, protobufFileName, protobufPackageName, schemaSrc, sourceFileWriter.getGeneratedMarshallerClasses());
        }
        return result;
    }

    private String getInitializerClassName(Element annotatedElement, AutoProtoSchemaBuilder builderAnnotation) {
        return builderAnnotation.className().isEmpty() ? annotatedElement.getSimpleName() + "Impl" : builderAnnotation.className();
    }

    private String getInitializerFQClassName(TypeElement annotatedElement, AutoProtoSchemaBuilder builderAnnotation) {
        String initializerClassName = this.getInitializerClassName(annotatedElement, builderAnnotation);
        PackageElement packageElement = this.elements.getPackageOf(annotatedElement);
        return packageElement.isUnnamed() ? initializerClassName : packageElement.getQualifiedName().toString() + '.' + initializerClassName;
    }

    private InitializerDependencies processDependencies(RoundEnvironment roundEnv, SerializationContext serCtx, Element annotatedElement, AutoProtoSchemaBuilder builderAnnotation) throws IOException {
        List<Object> dependencies = Collections.emptyList();
        try {
            builderAnnotation.dependsOn();
        }
        catch (MirroredTypesException mte) {
            dependencies = mte.getTypeMirrors();
        }
        LinkedHashSet<String> initializerClassNames = new LinkedHashSet<String>(dependencies.size());
        HashMap<XClass, String> depClasses = new HashMap<XClass, String>();
        for (TypeMirror typeMirror : dependencies) {
            TypeElement dependencyElement = (TypeElement)this.types.asElement(typeMirror);
            AutoProtoSchemaBuilder dependencyAnnotation = dependencyElement.getAnnotation(AutoProtoSchemaBuilder.class);
            if (dependencyAnnotation == null) {
                throw new AnnotationProcessingException(annotatedElement, "Dependency %s is not annotated with @AutoProtoSchemaBuilder annotation", dependencyElement.getQualifiedName().toString());
            }
            String initializerFqn = this.getInitializerFQClassName(dependencyElement, dependencyAnnotation);
            initializerClassNames.add(initializerFqn);
            Map<XClass, String> xclasses = this.processElement(false, roundEnv, serCtx, dependencyElement, dependencyAnnotation);
            depClasses.putAll(xclasses);
        }
        return new InitializerDependencies(initializerClassNames, depClasses);
    }

    private void warnOverrideExistingMethods(TypeElement typeElement, MirrorClassFactory typeFactory) {
        XClass annotatedType = typeFactory.fromTypeMirror(typeElement.asType());
        this.warnOverrideExistingMethod(annotatedType, "getProtoFileName", new XClass[0]);
        this.warnOverrideExistingMethod(annotatedType, "getProtoFile", new XClass[0]);
        XClass serializationContextClass = typeFactory.fromClass(SerializationContext.class);
        this.warnOverrideExistingMethod(annotatedType, "registerSchema", serializationContextClass);
        this.warnOverrideExistingMethod(annotatedType, "registerMarshallers", serializationContextClass);
    }

    private void warnOverrideExistingMethod(XClass xclass, String methodName, XClass ... argTypes) {
        XMethod method = xclass.getMethod(methodName, argTypes);
        if (method != null && !Modifier.isAbstract(method.getModifiers())) {
            this.reportWarning(((HasModelElement)method).getElement(), "Code generated by @AutoProtoSchemaBuilder processor will override your %s.%s method.", method.getDeclaringClass().getName(), method.getName());
        }
    }

    private void generateSerializationContextInitializer(Element annotatedElement, String annotatedElementFQN, AutoProtoSchemaBuilder annotation, Set<String> serCtxInitDeps, Collection<? extends TypeMirror> classes, String packageName, String initializerClassName, String fileName, String protobufPackageName, String schemaSrc, Set<String> generatedMarshallerClasses) throws IOException {
        JavaFileObject javaFileObject;
        String initializerFQN;
        String string = initializerFQN = packageName != null ? packageName + '.' + initializerClassName : initializerClassName;
        if (this.elements.getTypeElement(initializerFQN) != null) {
            this.logDebug("The class to be generated for \"%s\" already exists in source path: %s", annotatedElementFQN, initializerFQN);
        }
        Element[] originatingElements = new Element[classes.size() + 1];
        int i = 0;
        for (TypeMirror typeMirror : classes) {
            originatingElements[i++] = this.types.asElement(typeMirror);
        }
        originatingElements[i] = annotatedElement;
        String schemaFilePath = annotation.schemaFilePath();
        if (!schemaFilePath.isEmpty()) {
            this.writeSchema(schemaFilePath, fileName, schemaSrc, originatingElements, annotatedElement);
        } else {
            schemaFilePath = null;
        }
        try {
            javaFileObject = this.filer.createSourceFile(initializerFQN, originatingElements);
        }
        catch (FilerException fe) {
            throw new AnnotationProcessingException(fe, annotatedElement, "%s", fe.getMessage());
        }
        IndentWriter iw = new IndentWriter();
        iw.append((CharSequence)"/*\n");
        iw.append((CharSequence)" Generated by ").append((CharSequence)this.getClass().getName()).append((CharSequence)"\n");
        iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.PACKAGE ? " for package " : " for class ")).append((CharSequence)annotatedElementFQN).append((CharSequence)"\n");
        iw.append((CharSequence)" annotated with ").append((CharSequence)String.valueOf(annotation)).append((CharSequence)"\n");
        iw.append((CharSequence)" */\n\n");
        if (packageName != null) {
            iw.append((CharSequence)"package ").append((CharSequence)packageName).append((CharSequence)";\n\n");
        }
        AutoProtoSchemaBuilderAnnotationProcessor.addGeneratedAnnotation(iw);
        AutoProtoSchemaBuilderAnnotationProcessor.addSchemaBuilderAnnotation(iw, initializerClassName, fileName, schemaFilePath, protobufPackageName, classes, serCtxInitDeps, annotation.service());
        iw.append((CharSequence)"public class ").append((CharSequence)initializerClassName);
        if (annotatedElement.getKind() == ElementKind.PACKAGE) {
            iw.append((CharSequence)" implements ").append((CharSequence)SerializationContextInitializer.class.getName()).append((CharSequence)" {\n\n");
        } else {
            iw.append((CharSequence)(annotatedElement.getKind() == ElementKind.INTERFACE ? " implements " : " extends ")).append((CharSequence)annotatedElementFQN).append((CharSequence)" {\n\n");
        }
        iw.inc();
        if (schemaFilePath == null) {
            iw.append((CharSequence)"private static final String PROTO_SCHEMA = ").append((CharSequence)this.makeStringLiteral(schemaSrc)).append((CharSequence)";\n\n");
        }
        int k = 0;
        for (String s : serCtxInitDeps) {
            iw.append((CharSequence)"private final ").append((CharSequence)s).append((CharSequence)" dep").append((CharSequence)String.valueOf(k++)).append((CharSequence)" = new ").append((CharSequence)s).append((CharSequence)"();\n\n");
        }
        iw.append((CharSequence)"@Override\npublic String getProtoFileName() { return \"").append((CharSequence)fileName).append((CharSequence)"\"; }\n\n");
        iw.append((CharSequence)"@Override\npublic String getProtoFile() { return ");
        if (schemaFilePath == null) {
            iw.append((CharSequence)"PROTO_SCHEMA");
        } else {
            iw.append((CharSequence)"org.infinispan.protostream.FileDescriptorSource.getResourceAsString(getClass(), getProtoFileName())");
        }
        iw.append((CharSequence)"; }\n\n");
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerSchema(org.infinispan.protostream.SerializationContext serCtx) throws java.io.IOException {\n");
        iw.inc();
        for (int j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append((CharSequence)"dep").append((CharSequence)String.valueOf(j)).append((CharSequence)".registerSchema(serCtx);\n");
        }
        if (schemaFilePath == null) {
            iw.append((CharSequence)"serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromString(getProtoFileName(), PROTO_SCHEMA));\n");
        } else {
            String resourceFile = schemaFilePath.replace('.', '/') + '/' + fileName;
            iw.append((CharSequence)"serCtx.registerProtoFiles(org.infinispan.protostream.FileDescriptorSource.fromResources(\"").append((CharSequence)resourceFile).append((CharSequence)"\"));\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n\n");
        iw.append((CharSequence)"@Override\n");
        iw.append((CharSequence)"public void registerMarshallers(org.infinispan.protostream.SerializationContext serCtx) {\n");
        iw.inc();
        for (int j = 0; j < serCtxInitDeps.size(); ++j) {
            iw.append((CharSequence)"dep").append((CharSequence)String.valueOf(j)).append((CharSequence)".registerMarshallers(serCtx);\n");
        }
        for (String name : generatedMarshallerClasses) {
            iw.append((CharSequence)"serCtx.registerMarshaller(new ").append((CharSequence)name).append((CharSequence)"());\n");
        }
        iw.dec();
        iw.append((CharSequence)"}\n");
        iw.dec();
        iw.append((CharSequence)"}\n");
        try (PrintWriter out = new PrintWriter(javaFileObject.openWriter());){
            out.print(iw.toString());
        }
        if (annotation.service()) {
            this.serviceLoaderFileGenerator.addProvider(initializerFQN, annotatedElement);
        }
    }

    private void writeSchema(String filePath, String fileName, String schemaSrc, Element[] originatingElements, Element annotatedElement) throws IOException {
        FileObject schemaFile;
        String pkg = filePath;
        if (pkg.startsWith("/")) {
            pkg = pkg.substring(1);
        }
        pkg = pkg.replace('/', '.');
        try {
            schemaFile = this.filer.createResource(StandardLocation.CLASS_OUTPUT, pkg, fileName, originatingElements);
        }
        catch (FilerException e) {
            throw new AnnotationProcessingException(e, annotatedElement, "Package %s already contains a resource file named %s", pkg, fileName);
        }
        try (PrintWriter out = new PrintWriter(schemaFile.openWriter());){
            out.print(schemaSrc);
        }
    }

    static void addGeneratedAnnotation(IndentWriter iw) {
        iw.append((CharSequence)"/**\n * WARNING: Generated code!\n */\n");
        String ISO8601Date = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        iw.append((CharSequence)"@javax.annotation.Generated(value=\"").append((CharSequence)AutoProtoSchemaBuilderAnnotationProcessor.class.getName()).append((CharSequence)"\", date=\"").append((CharSequence)ISO8601Date).append((CharSequence)"\",\n      comments=\"Please do not edit this file!\")\n");
    }

    private static void addSchemaBuilderAnnotation(IndentWriter iw, String className, String schemaFileName, String schemaFilePath, String schemaPackageName, Collection<? extends TypeMirror> classes, Set<String> dependsOn, boolean service) {
        boolean first;
        iw.append((CharSequence)"@").append((CharSequence)AUTOPROTOSCHEMABUILDER_ANNOTATION_NAME).append((CharSequence)"(\n");
        iw.inc();
        iw.append((CharSequence)"className = \"").append((CharSequence)className).append((CharSequence)"\",\n");
        iw.append((CharSequence)"schemaFileName = \"").append((CharSequence)schemaFileName).append((CharSequence)"\",\n");
        if (schemaFilePath != null) {
            iw.append((CharSequence)"schemaFilePath = \"").append((CharSequence)schemaFilePath).append((CharSequence)"\",\n");
        }
        if (schemaPackageName != null) {
            iw.append((CharSequence)"schemaPackageName = \"").append((CharSequence)schemaPackageName).append((CharSequence)"\",\n");
        }
        if (!dependsOn.isEmpty()) {
            iw.append((CharSequence)"dependsOn = {\n");
            iw.inc();
            first = true;
            for (String string : dependsOn) {
                if (first) {
                    first = false;
                } else {
                    iw.append((CharSequence)",\n");
                }
                iw.append((CharSequence)string).append((CharSequence)".class");
            }
            iw.append((CharSequence)"\n");
            iw.dec();
            iw.append((CharSequence)"},\n");
        }
        iw.append((CharSequence)"service = ").append((CharSequence)String.valueOf(service)).append((CharSequence)",\n");
        iw.append((CharSequence)"autoImportClasses = false,\n");
        if (!classes.isEmpty()) {
            iw.append((CharSequence)"classes = {\n");
            iw.inc();
            first = true;
            for (TypeMirror typeMirror : classes) {
                if (first) {
                    first = false;
                } else {
                    iw.append((CharSequence)",\n");
                }
                iw.append((CharSequence)typeMirror.toString()).append((CharSequence)".class");
            }
            iw.append((CharSequence)"\n");
            iw.dec();
            iw.append((CharSequence)"}\n");
        }
        iw.dec();
        iw.append((CharSequence)")\n");
    }

    private String makeStringLiteral(String s) {
        StringBuilder sb = new StringBuilder(s.length() + 2);
        sb.append('\"');
        block5: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': {
                    sb.append("\\n\" +\n\"");
                    continue block5;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block5;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block5;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }

    private String makeClassName(TypeElement e) {
        return this.makeNestedClassName(e, e.getSimpleName().toString());
    }

    private String makeNestedClassName(TypeElement e, String className) {
        Element enclosingElement = e.getEnclosingElement();
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return packageElement.isUnnamed() ? className : packageElement.getQualifiedName() + "." + className;
        }
        TypeElement typeElement = (TypeElement)enclosingElement;
        return this.makeNestedClassName(typeElement, typeElement.getSimpleName() + "$" + className);
    }

    static final class InitializerDependencies {
        final Set<String> initializerClassNames;
        final Map<XClass, String> depClasses;

        InitializerDependencies(Set<String> initializerClassNames, Map<XClass, String> depClasses) {
            this.initializerClassNames = initializerClassNames;
            this.depClasses = depClasses;
        }
    }

    private static final class AnnotationProcessingException
    extends RuntimeException {
        final Element location;
        final String message;
        final Object[] msgParams;

        AnnotationProcessingException(Element location, String message, Object ... msgParams) {
            this.location = location;
            this.message = message;
            this.msgParams = msgParams;
        }

        AnnotationProcessingException(Throwable cause, Element location, String message, Object ... msgParams) {
            super(cause);
            this.location = location;
            this.message = message;
            this.msgParams = msgParams;
        }
    }
}

