/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.proto.compatibility;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.ProtoLock;
import org.infinispan.protostream.impl.parser.ProtostreamProtoParser;

@Mojo(name="proto-schema-compatibility-check", defaultPhase=LifecyclePhase.VERIFY, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true)
public class ProtoCompatibilityMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    private boolean commitProtoLock;
    @Parameter(defaultValue="${basedir}")
    private String protoLockRoot;
    @Parameter(defaultValue="${project.build.directory}/classes/proto", readonly=true)
    private String protoSourceRoot;
    @Parameter
    private String remoteLockFiles;
    @Parameter(defaultValue="${session}")
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        block19: {
            try {
                if (this.skip) {
                    this.getLog().info((CharSequence)"Skipping proto compatibility check");
                    return;
                }
                Path lockFile = Paths.get(this.protoLockRoot, "proto.lock");
                boolean lockFileExists = Files.exists(lockFile, new LinkOption[0]);
                if (!(this.commitProtoLock || lockFileExists || this.remoteCheck())) {
                    this.getLog().info((CharSequence)"Ignoring protolock check as there isn't an existing proto.lock file, commitProtoLock=false and no remoteLockFiles are specified.");
                    return;
                }
                ProtoLock protoNew = this.protoLockFromDir(Paths.get(this.protoSourceRoot, new String[0]));
                if (lockFileExists) {
                    ProtoLock protoOld;
                    try (InputStream is = Files.newInputStream(lockFile, new OpenOption[0]);){
                        protoOld = ProtoLock.readLockFile((InputStream)is);
                    }
                    protoOld.checkCompatibility(protoNew, true);
                    this.getLog().info((CharSequence)String.format("Backwards compatibility check against local file '%s' passed.", lockFile));
                }
                if (this.remoteCheck()) {
                    this.checkRemoteCompatibility(protoNew);
                }
                if (!this.commitProtoLock) break block19;
                try (OutputStream os = Files.newOutputStream(lockFile, new OpenOption[0]);){
                    protoNew.writeLockFile(os);
                }
                this.getLog().info((CharSequence)(lockFileExists ? "Schema changes committed to proto.lock." : "Initialized protolock."));
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while running protolock", (Exception)e);
            }
        }
    }

    private ProtoLock protoLockFromDir(Path protoRoot) throws IOException {
        List<Path> protoFiles;
        try (Stream<Path> stream = Files.walk(protoRoot, new FileVisitOption[0]);){
            protoFiles = stream.filter(p -> p.getFileName().toString().endsWith(".proto")).toList();
        }
        FileDescriptorSource fds = new FileDescriptorSource();
        for (Path p2 : protoFiles) {
            fds.addProtoFile(protoRoot.relativize(p2).toString(), p2.toFile());
        }
        ProtostreamProtoParser parser = new ProtostreamProtoParser(Configuration.builder().build());
        Map descriptors = parser.parse(fds);
        return new ProtoLock(descriptors.values());
    }

    private void checkRemoteCompatibility(ProtoLock currentState) throws IOException {
        if (this.session.isOffline()) {
            this.getLog().info((CharSequence)"Skipping backwards compatibility check against remote files as maven is in Offline mode");
            return;
        }
        for (String file : this.remoteLockFiles.split(",")) {
            this.getLog().info((CharSequence)String.format("Checking backwards compatibility check against remote file '%s'", file));
            try (InputStream is = new URL(file).openStream();){
                ProtoLock remoteLockFile = ProtoLock.readLockFile((InputStream)is);
                remoteLockFile.checkCompatibility(currentState, true);
            }
            this.getLog().info((CharSequence)String.format("Backwards compatibility check against remote file '%s' passed", file));
        }
    }

    private boolean remoteCheck() {
        return this.remoteLockFiles != null && !this.remoteLockFiles.isEmpty();
    }
}

