/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KeyUtil;

public final class DefaultHashAlgorithm
extends Enum<DefaultHashAlgorithm>
implements HashAlgorithm {
    public static final /* enum */ DefaultHashAlgorithm NATIVE_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm CRC_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1_64_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1A_64_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1_32_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm FNV1A_32_HASH = new DefaultHashAlgorithm();
    public static final /* enum */ DefaultHashAlgorithm KETAMA_HASH = new DefaultHashAlgorithm();
    private static final long FNV_64_INIT = -3750763034362895579L;
    private static final long FNV_64_PRIME = 1099511628211L;
    private static final long FNV_32_INIT = 2166136261L;
    private static final long FNV_32_PRIME = 16777619L;
    private static MessageDigest msgHashDigest;
    private static final /* synthetic */ DefaultHashAlgorithm[] $VALUES;

    public static DefaultHashAlgorithm[] values() {
        return (DefaultHashAlgorithm[])$VALUES.clone();
    }

    public static DefaultHashAlgorithm valueOf(String name) {
        return Enum.valueOf(DefaultHashAlgorithm.class, name);
    }

    @Override
    public long hash(String k) {
        long rv = 0L;
        int len = k.length();
        switch (this.ordinal()) {
            case 0: {
                rv = k.hashCode();
                break;
            }
            case 1: {
                CRC32 crc32 = new CRC32();
                crc32.update(KeyUtil.getKeyBytes(k));
                rv = crc32.getValue() >> 16 & 0x7FFFL;
                break;
            }
            case 2: {
                rv = -3750763034362895579L;
                for (int i = 0; i < len; ++i) {
                    rv *= 1099511628211L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case 3: {
                rv = -3750763034362895579L;
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 1099511628211L;
                }
                break;
            }
            case 4: {
                rv = 2166136261L;
                for (int i = 0; i < len; ++i) {
                    rv *= 16777619L;
                    rv ^= (long)k.charAt(i);
                }
                break;
            }
            case 5: {
                rv = 2166136261L;
                for (int i = 0; i < len; ++i) {
                    rv ^= (long)k.charAt(i);
                    rv *= 16777619L;
                }
                break;
            }
            case 6: {
                byte[] bKey = DefaultHashAlgorithm.computeHashDigest(k);
                rv = (long)(bKey[3] & 0xFF) << 24 | (long)(bKey[2] & 0xFF) << 16 | (long)(bKey[1] & 0xFF) << 8 | (long)(bKey[0] & 0xFF);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return rv & 0xFFFFFFFFL;
    }

    public static byte[] computeHashDigest(String k) {
        MessageDigest msgDigest;
        try {
            msgDigest = (MessageDigest)msgHashDigest.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("clone of SHA-384 not supported", e);
        }
        msgDigest.update(KeyUtil.getKeyBytes(k));
        return msgDigest.digest();
    }

    private static /* synthetic */ DefaultHashAlgorithm[] $values() {
        return new DefaultHashAlgorithm[]{NATIVE_HASH, CRC_HASH, FNV1_64_HASH, FNV1A_64_HASH, FNV1_32_HASH, FNV1A_32_HASH, KETAMA_HASH};
    }

    static {
        $VALUES = DefaultHashAlgorithm.$values();
        msgHashDigest = null;
        try {
            msgHashDigest = MessageDigest.getInstance("SHA-384");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-384 not supported", e);
        }
    }
}

