/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan9;

import java.io.IOException;
import java.io.ObjectInput;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.util.ReadOnlySegmentAwareCollection;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.common.Ids;

public class CollectionExternalizer
extends AbstractMigratorExternalizer<Collection> {
    private static final int ARRAY_LIST = 0;
    private static final int LINKED_LIST = 1;
    private static final int SINGLETON_LIST = 2;
    private static final int EMPTY_LIST = 3;
    private static final int HASH_SET = 4;
    private static final int TREE_SET = 5;
    private static final int SINGLETON_SET = 6;
    private static final int SYNCHRONIZED_SET = 7;
    private static final int ARRAY_DEQUE = 8;
    private static final int READ_ONLY_SEGMENT_AWARE_COLLECTION = 9;
    private static final int ENTRY_SET = 10;
    private static final int EMPTY_SET = 11;
    private static final int SYNCHRONIZED_LIST = 12;

    public CollectionExternalizer() {
        super(CollectionExternalizer.getClasses(), Ids.COLLECTIONS);
    }

    @Override
    public Collection readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        return switch (magicNumber) {
            case 0, 9 -> (ArrayList)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            case 1 -> (LinkedList)MarshallUtil.unmarshallCollectionUnbounded((ObjectInput)input, LinkedList::new);
            case 2 -> Collections.singletonList(input.readObject());
            case 12 -> Collections.synchronizedList((List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new));
            case 3 -> Collections.emptyList();
            case 4 -> (HashSet)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet());
            case 5 -> {
                Comparator comparator = (Comparator)input.readObject();
                yield (TreeSet)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new TreeSet(comparator));
            }
            case 6 -> Collections.singleton(input.readObject());
            case 7 -> Collections.synchronizedSet((Set)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet()));
            case 8 -> (ArrayDeque)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayDeque::new);
            case 10 -> (Set)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet(), in -> new AbstractMap.SimpleEntry<Object, Object>(in.readObject(), in.readObject()));
            case 11 -> Collections.emptySet();
            default -> throw new IllegalStateException("Unknown Set type: " + magicNumber);
        };
    }

    public static Set<Class<? extends Collection>> getClasses() {
        Set typeClasses = Util.asSet((Object[])new Class[]{ArrayList.class, LinkedList.class, HashSet.class, TreeSet.class, ArrayDeque.class, ReadOnlySegmentAwareCollection.class});
        typeClasses.addAll(CollectionExternalizer.getSupportedPrivateClasses());
        return typeClasses;
    }

    public static Set<Class<Collection>> getSupportedPrivateClasses() {
        return Set.of(CollectionExternalizer.getPrivateArrayListClass(), CollectionExternalizer.getPrivateArrayListSubListClass(), CollectionExternalizer.getPrivateAbstractListRandomAccessSubListClass(), CollectionExternalizer.getPrivateSynchronizedListClass(), CollectionExternalizer.getPrivateUnmodifiableListClass(), CollectionExternalizer.getPrivateEmptyListClass(), CollectionExternalizer.getPrivateEmptySetClass(), CollectionExternalizer.getPrivateSingletonListClass(), CollectionExternalizer.getPrivateSingletonSetClass(), CollectionExternalizer.getPrivateSynchronizedSetClass(), CollectionExternalizer.getPrivateUnmodifiableSetClass(), CollectionExternalizer.getPrivateImmutableList12Class(), CollectionExternalizer.getPrivateImmutableListNClass());
    }

    private static Class<Collection> getPrivateArrayListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Arrays$ArrayList");
    }

    private static Class<Collection> getPrivateArrayListSubListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.ArrayList$SubList");
    }

    private static Class<Collection> getPrivateAbstractListRandomAccessSubListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.AbstractList$RandomAccessSubList");
    }

    public static Class<Collection> getPrivateSynchronizedListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SynchronizedRandomAccessList");
    }

    private static Class<Collection> getPrivateUnmodifiableListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableRandomAccessList");
    }

    private static Class<Collection> getPrivateEmptyListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptyList");
    }

    private static Class<Collection> getPrivateEmptySetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$EmptySet");
    }

    private static Class<Collection> getPrivateSingletonListClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonList");
    }

    public static Class<Collection> getPrivateSingletonSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SingletonSet");
    }

    public static Class<Collection> getPrivateSynchronizedSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$SynchronizedSet");
    }

    private static Class<Collection> getPrivateUnmodifiableSetClass() {
        return CollectionExternalizer.getCollectionClass("java.util.Collections$UnmodifiableSet");
    }

    private static Class<Collection> getPrivateImmutableList12Class() {
        return CollectionExternalizer.getCollectionClass("java.util.ImmutableCollections$List12");
    }

    private static Class<Collection> getPrivateImmutableListNClass() {
        return CollectionExternalizer.getCollectionClass("java.util.ImmutableCollections$ListN");
    }

    private static Class<Collection> getCollectionClass(String className) {
        return Util.loadClass((String)className, (ClassLoader)Collection.class.getClassLoader());
    }
}

