/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.tools.store.migrator.marshaller.infinispan8;

import com.google.errorprone.annotations.Immutable;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.tools.store.migrator.marshaller.common.AbstractMigratorExternalizer;
import org.infinispan.tools.store.migrator.marshaller.infinispan8.ExternalizerTable;

@Immutable
class SetExternalizer
extends AbstractMigratorExternalizer<Set> {
    private static final int HASH_SET = 0;
    private static final int TREE_SET = 1;

    public SetExternalizer() {
        super(Set.of(HashSet.class, TreeSet.class), (Integer)ExternalizerTable.JDK_SETS);
    }

    @Override
    public Set readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int magicNumber = input.readUnsignedByte();
        switch (magicNumber) {
            case 0: {
                return (Set)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new HashSet());
            }
            case 1: {
                Comparator comparator = (Comparator)input.readObject();
                return (Set)MarshallUtil.unmarshallCollection((ObjectInput)input, s -> new TreeSet(comparator));
            }
        }
        throw new IllegalStateException("Unknown Set type: " + magicNumber);
    }
}

